/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.util.ResourceGuard;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceGuardTest {
    ResourceGuardTest() {
    }

    @Test
    void testClose() {
        ResourceGuard resourceGuard = new ResourceGuard();
        Assertions.assertThat((boolean)resourceGuard.isClosed()).isFalse();
        resourceGuard.close();
        Assertions.assertThat((boolean)resourceGuard.isClosed()).isTrue();
        Assertions.assertThatThrownBy(() -> ((ResourceGuard)resourceGuard).acquireResource()).isInstanceOf(IOException.class);
    }

    @Test
    void testAcquireReleaseClose() throws IOException {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isOne();
        lease.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isZero();
        resourceGuard.close();
        Assertions.assertThat((boolean)resourceGuard.isClosed()).isTrue();
    }

    @Test
    void testCloseBlockIfAcquired() throws Exception {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        AtomicBoolean checker = new AtomicBoolean(true);
        Thread closerThread = new Thread(() -> {
            resourceGuard.close();
            checker.set(false);
        });
        closerThread.start();
        while (!resourceGuard.isClosed()) {
            Thread.yield();
        }
        Assertions.assertThat((boolean)checker.get()).isTrue();
        Assertions.assertThatThrownBy(() -> ((ResourceGuard)resourceGuard).acquireResource()).isInstanceOf(IOException.class);
        lease.close();
        closerThread.join(60000L);
        Assertions.assertThat((boolean)checker.get()).isFalse();
    }

    @Test
    void testInterruptHandledCorrectly() throws Exception {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        AtomicBoolean checker = new AtomicBoolean(true);
        Thread closerThread = new Thread(() -> {
            resourceGuard.close();
            checker.set(false);
        });
        closerThread.start();
        while (!resourceGuard.isClosed()) {
            Thread.yield();
        }
        closerThread.interrupt();
        closerThread.join(100L);
        Assertions.assertThat((boolean)checker.get()).isTrue();
        lease.close();
        closerThread.join(60000L);
        Assertions.assertThat((boolean)checker.get()).isFalse();
    }

    @Test
    void testLeaseCloseIsIdempotent() throws Exception {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease1 = resourceGuard.acquireResource();
        ResourceGuard.Lease lease2 = resourceGuard.acquireResource();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isEqualTo(2);
        lease1.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isOne();
        lease1.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isOne();
        lease2.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isZero();
        ResourceGuard.Lease lease3 = resourceGuard.acquireResource();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isOne();
        lease2.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isOne();
        lease3.close();
        Assertions.assertThat((int)resourceGuard.getLeaseCount()).isZero();
        resourceGuard.close();
    }
}

