/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;
import org.apache.flink.util.Reference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReferenceTest {
    ReferenceTest() {
    }

    @Test
    void testOwnedReferenceIsOwned() {
        Reference value = Reference.owned((Object)"foobar");
        Assertions.assertThat((boolean)value.isOwned()).isTrue();
    }

    @Test
    void testBorrowedReferenceIsNotOwned() {
        Reference value = Reference.borrowed((Object)"foobar");
        Assertions.assertThat((boolean)value.isOwned()).isFalse();
    }

    @Test
    void testOwnedReferenceReturnsSomeOwned() {
        String value = "foobar";
        Reference owned = Reference.owned((Object)"foobar");
        Assertions.assertThat((Optional)owned.owned()).hasValue((Object)"foobar");
    }

    @Test
    void testBorrowedReferenceReturnsEmptyOwned() {
        Reference value = Reference.borrowed((Object)"foobar");
        Assertions.assertThat((Optional)value.owned()).isEmpty();
    }
}

