/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.util.AbstractParameterTool;
import org.apache.flink.util.AbstractParameterToolTest;
import org.apache.flink.util.ParameterTool;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ParameterToolTest
extends AbstractParameterToolTest {
    ParameterToolTest() {
    }

    @Test
    void testFromCliArgs() {
        ParameterTool parameter = (ParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "-expectedCount", "15", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(7);
        this.validate((AbstractParameterTool)parameter);
        Assertions.assertThat((boolean)parameter.has("withoutValues")).isTrue();
        Assertions.assertThat((float)parameter.getFloat("negativeFloat")).isCloseTo(-0.58f, Offset.offset((Number)Float.valueOf(0.1f)));
        Assertions.assertThat((boolean)parameter.getBoolean("isWorking")).isTrue();
        Assertions.assertThat((byte)parameter.getByte("maxByte")).isEqualTo((byte)127);
        Assertions.assertThat((short)parameter.getShort("negativeShort")).isEqualTo((short)-1024);
    }

    @Test
    void testFromPropertiesFile(@TempDir File propertiesFile) throws IOException {
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        Path path = new File(propertiesFile, UUID.randomUUID().toString()).toPath();
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            props.store(out, "Test properties");
        }
        ParameterTool parameter = ParameterTool.fromPropertiesFile((File)path.toFile());
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(2);
        this.validate((AbstractParameterTool)parameter);
        parameter = ParameterTool.fromPropertiesFile((File)path.toFile());
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(2);
        this.validate((AbstractParameterTool)parameter);
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            parameter = ParameterTool.fromPropertiesFile((InputStream)fis);
        }
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(2);
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    void testFromMapOrProperties() {
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromMap((Map)props);
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(2);
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    void testSystemProperties() {
        System.setProperty("input", "myInput");
        System.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromSystemProperties();
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    void testMerged() {
        ParameterTool parameter1 = (ParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput"});
        System.setProperty("expectedCount", "15");
        ParameterTool parameter2 = ParameterTool.fromSystemProperties();
        ParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate((AbstractParameterTool)parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentExecutionConfigSerialization() throws ExecutionException, InterruptedException {
        int numInputs = 10;
        ArrayList<Object> input = new ArrayList<Object>(10);
        for (int i = 0; i < 10; ++i) {
            input.add("--" + UUID.randomUUID());
            input.add(UUID.randomUUID().toString());
        }
        String[] args = input.toArray(new String[0]);
        ParameterTool parameterTool = (ParameterTool)this.createParameterToolFromArgs(args);
        int numThreads = 5;
        int numSerializations = 100;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(100);
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(CompletableFuture.runAsync(() -> {
                    try {
                        this.serializeDeserialize(parameterTool);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executorService));
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void serializeDeserialize(ParameterTool parameterTool) throws IOException, ClassNotFoundException {
        parameterTool.get(UUID.randomUUID().toString());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(parameterTool);
            oos.close();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            ParameterTool parameterTool2 = (ParameterTool)ois.readObject();
        }
    }
}

