/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.MathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MathUtilTest {
    MathUtilTest() {
    }

    @Test
    void testLog2Computation() {
        Assertions.assertThat((int)MathUtils.log2floor((int)1)).isZero();
        Assertions.assertThat((int)MathUtils.log2floor((int)2)).isOne();
        Assertions.assertThat((int)MathUtils.log2floor((int)3)).isOne();
        Assertions.assertThat((int)MathUtils.log2floor((int)4)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.log2floor((int)5)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.log2floor((int)7)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.log2floor((int)8)).isEqualTo(3);
        Assertions.assertThat((int)MathUtils.log2floor((int)9)).isEqualTo(3);
        Assertions.assertThat((int)MathUtils.log2floor((int)16)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.log2floor((int)17)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.log2floor((int)8193)).isEqualTo(13);
        Assertions.assertThat((int)MathUtils.log2floor((int)Integer.MAX_VALUE)).isEqualTo(30);
        Assertions.assertThat((int)MathUtils.log2floor((int)-1)).isEqualTo(31);
        Assertions.assertThatThrownBy(() -> MathUtils.log2floor((int)0)).isInstanceOf(ArithmeticException.class);
    }

    @Test
    void testRoundDownToPowerOf2() {
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)0)).isZero();
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)1)).isOne();
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)2)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)3)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)4)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)5)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)6)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)7)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)8)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)9)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)15)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)16)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)17)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)31)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)32)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)33)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)42)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)63)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)64)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)125)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)25654)).isEqualTo(16384);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)34366363)).isEqualTo(0x2000000);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)63463463)).isEqualTo(0x2000000);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)1852987883)).isEqualTo(0x40000000);
        Assertions.assertThat((int)MathUtils.roundDownToPowerOf2((int)Integer.MAX_VALUE)).isEqualTo(0x40000000);
    }

    @Test
    void testRoundUpToPowerOf2() {
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0)).isZero();
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)1)).isOne();
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)2)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)3)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)4)).isEqualTo(4);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)5)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)6)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)7)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)8)).isEqualTo(8);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)9)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)15)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)16)).isEqualTo(16);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)17)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)31)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)32)).isEqualTo(32);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)33)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)42)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)63)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)64)).isEqualTo(64);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)125)).isEqualTo(128);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)25654)).isEqualTo(32768);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)34366363)).isEqualTo(0x4000000);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFF)).isEqualTo(0x4000000);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0x4000000)).isEqualTo(0x4000000);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFFE)).isEqualTo(0x40000000);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFFF)).isEqualTo(0x40000000);
        Assertions.assertThat((int)MathUtils.roundUpToPowerOfTwo((int)0x40000000)).isEqualTo(0x40000000);
    }

    @Test
    void testPowerOfTwo() {
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)1L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)2L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)4L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)8L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)32768L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)65536L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)0x40000000L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)0x80000000L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)0x20000000000L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)0x4000000000000000L)).isTrue();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)3L)).isFalse();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)5L)).isFalse();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)567923L)).isFalse();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)Integer.MAX_VALUE)).isFalse();
        Assertions.assertThat((boolean)MathUtils.isPowerOf2((long)Long.MAX_VALUE)).isFalse();
    }

    @Test
    void testFlipSignBit() {
        Assertions.assertThat((long)MathUtils.flipSignBit((long)Long.MIN_VALUE)).isZero();
        Assertions.assertThat((long)MathUtils.flipSignBit((long)0L)).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((long)MathUtils.flipSignBit((long)Long.MAX_VALUE)).isEqualTo(-1L);
        Assertions.assertThat((long)MathUtils.flipSignBit((long)-1L)).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((long)MathUtils.flipSignBit((long)42L)).isEqualTo(-9223372036854775766L);
        Assertions.assertThat((long)MathUtils.flipSignBit((long)-42L)).isEqualTo(9223372036854775766L);
    }

    @Test
    void testDivideRoundUp() {
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)0, (int)1)).isZero();
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)0, (int)2)).isZero();
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)1, (int)1)).isOne();
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)1, (int)2)).isOne();
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)2, (int)1)).isEqualTo(2);
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)2, (int)2)).isOne();
        Assertions.assertThat((int)MathUtils.divideRoundUp((int)2, (int)3)).isOne();
    }

    @Test
    void testDivideRoundUpNegativeDividend() {
        Assertions.assertThatThrownBy(() -> MathUtils.divideRoundUp((int)-1, (int)1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDivideRoundUpNegativeDivisor() {
        Assertions.assertThatThrownBy(() -> MathUtils.divideRoundUp((int)1, (int)-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDivideRoundUpZeroDivisor() {
        Assertions.assertThatThrownBy(() -> MathUtils.divideRoundUp((int)1, (int)0)).isInstanceOf(IllegalArgumentException.class);
    }
}

