/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.util.LambdaUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class LambdaUtilTest {
    LambdaUtilTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRunWithContextClassLoaderRunnable() {
        ClassLoader aPrioriContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader original = new URLClassLoader(new URL[0]);
            URLClassLoader temp = new URLClassLoader(new URL[0]);
            Thread.currentThread().setContextClassLoader(original);
            ((ObjectAssert)LambdaUtil.withContextClassLoader((ClassLoader)temp, () -> Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()))).isSameAs((Object)temp);
            Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isSameAs((Object)original);
        }
        finally {
            Thread.currentThread().setContextClassLoader(aPrioriContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRunWithContextClassLoaderSupplier() {
        ClassLoader aPrioriContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader original = new URLClassLoader(new URL[0]);
            URLClassLoader temp = new URLClassLoader(new URL[0]);
            Thread.currentThread().setContextClassLoader(original);
            LambdaUtil.withContextClassLoader((ClassLoader)temp, () -> {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isSameAs((Object)temp);
                return true;
            });
            Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isSameAs((Object)original);
        }
        finally {
            Thread.currentThread().setContextClassLoader(aPrioriContextClassLoader);
        }
    }
}

