/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.CompressedSerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompressedSerializedValueTest {
    CompressedSerializedValueTest() {
    }

    @Test
    void testSimpleValue() throws Exception {
        String value = "teststring";
        CompressedSerializedValue v = CompressedSerializedValue.fromObject((Object)"teststring");
        CompressedSerializedValue copy = (CompressedSerializedValue)CommonTestUtils.createCopySerializable((Serializable)v);
        Assertions.assertThat((String)((String)v.deserializeValue(this.getClass().getClassLoader()))).isEqualTo("teststring");
        Assertions.assertThat((String)((String)copy.deserializeValue(this.getClass().getClassLoader()))).isEqualTo("teststring");
        Assertions.assertThat((Object)copy).isEqualTo((Object)v);
        Assertions.assertThat((Object)copy).hasSameHashCodeAs((Object)v.hashCode());
        Assertions.assertThat((String)v.toString()).isNotNull();
        Assertions.assertThat((String)copy.toString()).isNotNull();
        Assertions.assertThat((int)v.getSize()).isNotEqualTo(0);
        Assertions.assertThat((byte[])copy.getByteArray()).isEqualTo((Object)v.getByteArray());
        byte[] bytes = v.getByteArray();
        CompressedSerializedValue saved = CompressedSerializedValue.fromBytes((byte[])Arrays.copyOf(bytes, bytes.length));
        Assertions.assertThat((Object)saved).isEqualTo((Object)v);
        Assertions.assertThat((byte[])saved.getByteArray()).isEqualTo((Object)v.getByteArray());
    }

    @Test
    void testNullValue() {
        Assertions.assertThatThrownBy(() -> CompressedSerializedValue.fromObject(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromNullBytes() {
        Assertions.assertThatThrownBy(() -> CompressedSerializedValue.fromBytes(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromEmptyBytes() {
        Assertions.assertThatThrownBy(() -> CompressedSerializedValue.fromBytes((byte[])new byte[0])).isInstanceOf(IllegalArgumentException.class);
    }
}

