/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.util.CloseableIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CloseableIteratorTest {
    private static final String[] ELEMENTS = new String[]{"element-1", "element-2"};

    CloseableIteratorTest() {
    }

    @Test
    void testFlattenEmpty() throws Exception {
        List<CloseableIterator> iterators = Arrays.asList(CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[0]), CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[]{CloseableIterator.empty()}), CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[]{CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[0])}));
        for (CloseableIterator i : iterators) {
            Assertions.assertThat((Iterator)i).isExhausted();
            i.close();
        }
    }

    @Test
    void testFlattenIteration() {
        CloseableIterator iterator = CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[]{CloseableIterator.ofElement((Object)ELEMENTS[0], unused -> {}), CloseableIterator.ofElement((Object)ELEMENTS[1], unused -> {})});
        ArrayList iterated = new ArrayList();
        iterator.forEachRemaining(iterated::add);
        Assertions.assertThat((Object[])iterated.toArray()).isEqualTo((Object)ELEMENTS);
    }

    @Test
    void testFlattenErrorHandling() {
        ArrayList closed = new ArrayList();
        CloseableIterator[] closeableIteratorArray = new CloseableIterator[2];
        closeableIteratorArray[0] = CloseableIterator.ofElement((Object)ELEMENTS[0], e -> {
            closed.add(e);
            throw new TestException();
        });
        closeableIteratorArray[1] = CloseableIterator.ofElement((Object)ELEMENTS[1], closed::add);
        CloseableIterator iterator = CloseableIterator.flatten((CloseableIterator[])closeableIteratorArray);
        Assertions.assertThatThrownBy(() -> iterator.close()).isInstanceOf(TestException.class);
        Assertions.assertThat((Object[])closed.toArray()).isEqualTo((Object)ELEMENTS);
    }

    private static class TestException
    extends RuntimeException {
        private TestException() {
        }
    }
}

