/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public abstract class ParserTestBase<T> {
    public abstract String[] getValidTestValues();

    public abstract T[] getValidTestResults();

    public abstract String[] getInvalidTestValues();

    public abstract boolean allowsEmptyField();

    public abstract FieldParser<T> getParser();

    public abstract Class<T> getTypeClass();

    @Test
    void testTest() {
        Assertions.assertThat(this.getParser()).isNotNull();
        Assertions.assertThat(this.getTypeClass()).isNotNull();
        Assertions.assertThat((Object[])this.getValidTestValues()).isNotNull();
        Assertions.assertThat((Object[])this.getValidTestResults()).isNotNull();
        Assertions.assertThat((Object[])this.getInvalidTestValues()).isNotNull();
        Assertions.assertThat((Object[])this.getValidTestValues()).hasSameSizeAs(this.getValidTestResults());
    }

    @Test
    void testGetValue() {
        FieldParser<T> parser = this.getParser();
        Object created = parser.createValue();
        ((ObjectAssert)Assertions.assertThat((Object)created).isNotNull()).isInstanceOf(this.getTypeClass());
    }

    @Test
    void testValidStringInIsolation() {
        String[] testValues = this.getValidTestValues();
        T[] results = this.getValidTestResults();
        for (int i = 0; i < testValues.length; ++i) {
            FieldParser<T> parser1 = this.getParser();
            FieldParser<T> parser2 = this.getParser();
            FieldParser<T> parser3 = this.getParser();
            byte[] bytes1 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
            byte[] bytes2 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
            byte[] bytes3 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
            int numRead1 = parser1.parseField(bytes1, 0, bytes1.length, new byte[]{124}, parser1.createValue());
            int numRead2 = parser2.parseField(bytes2, 0, bytes2.length, new byte[]{38, 38}, parser2.createValue());
            int numRead3 = parser3.parseField(bytes3, 0, bytes3.length, new byte[]{57, 57, 57}, parser3.createValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead1).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead2).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead3).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            Assertions.assertThat((byte[])bytes1).hasSize(numRead1);
            Assertions.assertThat((byte[])bytes2).hasSize(numRead2);
            Assertions.assertThat((byte[])bytes3).hasSize(numRead3);
            Assertions.assertThat((Object)parser1.getLastResult()).isEqualTo(results[i]);
            Assertions.assertThat((Object)parser2.getLastResult()).isEqualTo(results[i]);
            Assertions.assertThat((Object)parser3.getLastResult()).isEqualTo(results[i]);
        }
    }

    @Test
    void testValidStringInIsolationWithEndDelimiter() {
        String[] testValues = this.getValidTestValues();
        T[] results = this.getValidTestResults();
        for (int i = 0; i < testValues.length; ++i) {
            FieldParser<T> parser1 = this.getParser();
            FieldParser<T> parser2 = this.getParser();
            String testVal1 = testValues[i] + "|";
            String testVal2 = testValues[i] + "&&&&";
            byte[] bytes1 = testVal1.getBytes(ConfigConstants.DEFAULT_CHARSET);
            byte[] bytes2 = testVal2.getBytes(ConfigConstants.DEFAULT_CHARSET);
            int numRead1 = parser1.parseField(bytes1, 0, bytes1.length, new byte[]{124}, parser1.createValue());
            int numRead2 = parser2.parseField(bytes2, 0, bytes2.length, new byte[]{38, 38, 38, 38}, parser2.createValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead1).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead2).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            Assertions.assertThat((byte[])bytes1).hasSize(numRead1);
            Assertions.assertThat((byte[])bytes2).hasSize(numRead2);
            Assertions.assertThat((Object)parser1.getLastResult()).isEqualTo(results[i]);
            Assertions.assertThat((Object)parser2.getLastResult()).isEqualTo(results[i]);
        }
    }

    @Test
    void testConcatenated() {
        String[] testValues = this.getValidTestValues();
        T[] results = this.getValidTestResults();
        byte[] allBytesWithDelimiter = ParserTestBase.concatenate(testValues, new char[]{'|'}, true);
        byte[] allBytesNoDelimiterEnd = ParserTestBase.concatenate(testValues, new char[]{','}, false);
        FieldParser<T> parser1 = this.getParser();
        FieldParser<T> parser2 = this.getParser();
        Object val1 = parser1.createValue();
        Object val2 = parser2.createValue();
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < results.length; ++i) {
            pos1 = parser1.parseField(allBytesWithDelimiter, pos1, allBytesWithDelimiter.length, new byte[]{124}, val1);
            pos2 = parser2.parseField(allBytesNoDelimiterEnd, pos2, allBytesNoDelimiterEnd.length, new byte[]{44}, val2);
            ((AbstractIntegerAssert)Assertions.assertThat((int)pos1).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)pos2).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            Assertions.assertThat((Object)parser1.getLastResult()).isEqualTo(results[i]);
            Assertions.assertThat((Object)parser2.getLastResult()).isEqualTo(results[i]);
        }
    }

    @Test
    void testConcatenatedMultiCharDelimiter() {
        String[] testValues = this.getValidTestValues();
        T[] results = this.getValidTestResults();
        byte[] allBytesWithDelimiter = ParserTestBase.concatenate(testValues, new char[]{'&', '&', '&', '&'}, true);
        byte[] allBytesNoDelimiterEnd = ParserTestBase.concatenate(testValues, new char[]{'9', '9', '9'}, false);
        FieldParser<T> parser1 = this.getParser();
        FieldParser<T> parser2 = this.getParser();
        Object val1 = parser1.createValue();
        Object val2 = parser2.createValue();
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < results.length; ++i) {
            pos1 = parser1.parseField(allBytesWithDelimiter, pos1, allBytesWithDelimiter.length, new byte[]{38, 38, 38, 38}, val1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)pos1).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            Object result1 = parser1.getLastResult();
            Assertions.assertThat((Object)result1).isEqualTo(results[i]);
            pos2 = parser2.parseField(allBytesNoDelimiterEnd, pos2, allBytesNoDelimiterEnd.length, new byte[]{57, 57, 57}, val2);
            ((AbstractIntegerAssert)Assertions.assertThat((int)pos2).describedAs("Parser declared the valid value " + testValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
            Object result2 = parser2.getLastResult();
            Assertions.assertThat((Object)result2).isEqualTo(results[i]);
        }
    }

    @Test
    void testInValidStringInIsolation() {
        String[] testValues;
        for (String testValue : testValues = this.getInvalidTestValues()) {
            FieldParser<T> parser = this.getParser();
            byte[] bytes = testValue.getBytes(ConfigConstants.DEFAULT_CHARSET);
            int numRead = parser.parseField(bytes, 0, bytes.length, new byte[]{124}, parser.createValue());
            ((AbstractIntegerAssert)Assertions.assertThat((int)numRead).describedAs("Parser accepted the invalid value " + testValue + ".", new Object[0])).isEqualTo(-1);
        }
    }

    @Test
    void testInValidStringsMixedIn() {
        String[] validValues = this.getValidTestValues();
        T[] validResults = this.getValidTestResults();
        String[] invalidTestValues = this.getInvalidTestValues();
        FieldParser<T> parser = this.getParser();
        Object value = parser.createValue();
        for (String invalid : invalidTestValues) {
            String[] testLine = new String[validValues.length + 1];
            int splitPoint = validValues.length / 2;
            System.arraycopy(validValues, 0, testLine, 0, splitPoint);
            testLine[splitPoint] = invalid;
            System.arraycopy(validValues, splitPoint, testLine, splitPoint + 1, validValues.length - splitPoint);
            byte[] bytes = ParserTestBase.concatenate(testLine, new char[]{'%'}, true);
            int pos = 0;
            for (int i = 0; i < splitPoint; ++i) {
                pos = parser.parseField(bytes, pos, bytes.length, new byte[]{37}, value);
                ((AbstractIntegerAssert)Assertions.assertThat((int)pos).describedAs("Parser declared the valid value " + validValues[i] + " as invalid.", new Object[0])).isNotEqualTo(-1);
                Object result = parser.getLastResult();
                ((ObjectAssert)Assertions.assertThat((Object)result).describedAs("Parser parsed wrong.", new Object[0])).isEqualTo(validResults[i]);
            }
            pos = parser.parseField(bytes, pos, bytes.length, new byte[]{37}, value);
            ((AbstractIntegerAssert)Assertions.assertThat((int)pos).describedAs("Parser accepted the invalid value " + invalid + ".", new Object[0])).isEqualTo(-1);
        }
    }

    @Test
    public void testStaticParseMethod() throws IllegalAccessException, InvocationTargetException {
        Method parseMethod;
        try {
            parseMethod = this.getParser().getClass().getMethod("parseField", byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        String[] testValues = this.getValidTestValues();
        T[] results = this.getValidTestResults();
        for (int i = 0; i < testValues.length; ++i) {
            byte[] bytes = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
            Assertions.assertThat((Object)parseMethod.invoke(null, bytes, 0, bytes.length, Character.valueOf('|'))).isEqualTo(results[i]);
        }
    }

    @Test
    void testStaticParseMethodWithInvalidValues() {
        String[] testValues;
        Method parseMethod;
        try {
            parseMethod = this.getParser().getClass().getMethod("parseField", byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        for (String testValue : testValues = this.getInvalidTestValues()) {
            byte[] bytes = testValue.getBytes(ConfigConstants.DEFAULT_CHARSET);
            Method finalParseMethod = parseMethod;
            Assertions.assertThatThrownBy(() -> finalParseMethod.invoke(null, bytes, 0, bytes.length, Character.valueOf('|'))).isInstanceOf(InvocationTargetException.class);
        }
    }

    private static byte[] concatenate(String[] values, char[] delimiter, boolean delimiterAtEnd) {
        int len = 0;
        for (String s : values) {
            len += s.length() + delimiter.length;
        }
        if (!delimiterAtEnd) {
            len -= delimiter.length;
        }
        int currPos = 0;
        byte[] result = new byte[len];
        for (int i = 0; i < values.length; ++i) {
            String s;
            s = values[i];
            byte[] bytes = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
            int numBytes = bytes.length;
            System.arraycopy(bytes, 0, result, currPos, numBytes);
            currPos += numBytes;
            if (!delimiterAtEnd && i >= values.length - 1) continue;
            for (char c : delimiter) {
                result[currPos++] = (byte)c;
            }
        }
        return result;
    }

    @Test
    void testTrailingEmptyField() {
        FieldParser<T> parser = this.getParser();
        byte[] bytes = "||".getBytes(ConfigConstants.DEFAULT_CHARSET);
        for (int i = 0; i < 2; ++i) {
            int numRead = parser.parseField(bytes, i, bytes.length, new byte[]{124}, parser.createValue());
            Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
            if (this.allowsEmptyField()) {
                Assertions.assertThat((int)numRead).isNotEqualTo(-1);
                Assertions.assertThat((int)numRead).isEqualTo(i + 1);
            } else {
                Assertions.assertThat((int)numRead).isEqualTo(-1);
            }
            parser.resetParserState();
        }
    }
}

