/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringValueSerializationTest {
    private final Random rnd = new Random(2093486528937460234L);

    StringValueSerializationTest() {
    }

    @Test
    void testNonNullValues() throws IOException {
        String[] testStrings = new String[]{"a", "", "bcd", "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", "", "non-empty"};
        StringValueSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testLongValues() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000)};
        StringValueSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testMixedValues() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), ""};
        StringValueSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testBinaryCopyOfLongStrings() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), ""};
        StringValueSerializationTest.testCopy(testStrings);
    }

    public static void testSerialization(String[] values) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputViewStreamWrapper serializer = new DataOutputViewStreamWrapper((OutputStream)baos);
        for (String value : values) {
            StringValue sv = new StringValue((CharSequence)value);
            sv.write((DataOutputView)serializer);
        }
        serializer.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputViewStreamWrapper deserializer = new DataInputViewStreamWrapper((InputStream)bais);
        int num = 0;
        while (bais.available() > 0) {
            StringValue deser = new StringValue();
            deser.read((DataInputView)deserializer);
            Assertions.assertThat((String)values[num]).isEqualTo(deser.getValue());
            ++num;
        }
        Assertions.assertThat((Object[])values).hasSize(num);
    }

    public static void testCopy(String[] values) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputViewStreamWrapper serializer = new DataOutputViewStreamWrapper((OutputStream)baos);
        StringValue sValue = new StringValue();
        for (String value : values) {
            sValue.setValue((CharSequence)value);
            sValue.write((DataOutputView)serializer);
        }
        serializer.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)bais);
        ByteArrayOutputStream targetOutput = new ByteArrayOutputStream(4096);
        DataOutputViewStreamWrapper target = new DataOutputViewStreamWrapper((OutputStream)targetOutput);
        for (String value : values) {
            sValue.copy((DataInputView)source, (DataOutputView)target);
        }
        ByteArrayInputStream validateInput = new ByteArrayInputStream(targetOutput.toByteArray());
        DataInputViewStreamWrapper validate = new DataInputViewStreamWrapper((InputStream)validateInput);
        int num = 0;
        while (validateInput.available() > 0) {
            sValue.read((DataInputView)validate);
            Assertions.assertThat((String)values[num]).isEqualTo(sValue.getValue());
            ++num;
        }
        Assertions.assertThat((Object[])values).hasSize(num);
    }
}

