/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringSerializationTest {
    private final Random rnd = new Random(2093486528937460234L);
    private static final int HIGH_BIT = 128;

    StringSerializationTest() {
    }

    @Test
    void testNonNullValues() throws IOException {
        String[] testStrings = new String[]{"a", "", "bcd", "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", "", "non-empty"};
        StringSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testUnicodeValues() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\u007f'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0080', (char)'\u3fff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u4000', (char)'\uffff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\u3fff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\uffff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0080', (char)'\uffff')};
        StringSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testUnicodeSurrogatePairs() throws IOException {
        String[] symbols = new String[]{"\ud800\udf30", "\ud800\udf31", "\ud800\udf32", "\ud834\udf08", "\ud834\udf56", "\ud834\udd20", "\ud802\udc01", "\ud800\udc09", "\ud87e\udc9e", "\ud864\uddf8", "\ud840\udc0e", "\ud801\udc80", "\ud801\udc56", "\ud801\udc05", "\ud800\udf01"};
        String[] buffer = new String[100];
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < 100; ++j) {
                builder.append(symbols[random.nextInt(symbols.length)]);
            }
            buffer[i] = builder.toString();
        }
        StringSerializationTest.testSerialization(buffer);
    }

    @Test
    void testStringBinaryCompatibility() throws IOException {
        String[] testStrings;
        for (String testString : testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\u007f'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0080', (char)'\u3fff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u4000', (char)'\uffff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\u3fff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0001', (char)'\uffff'), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000, (char)'\u0080', (char)'\uffff')}) {
            byte[] oldBytes = StringSerializationTest.serializeBytes(testString, StringSerializationTest::oldWriteString);
            byte[] newBytes = StringSerializationTest.serializeBytes(testString, StringSerializationTest::newWriteString);
            Assertions.assertThat((byte[])newBytes).isEqualTo((Object)oldBytes);
            String oldString = StringSerializationTest.deserializeBytes(newBytes, StringSerializationTest::oldReadString);
            Assertions.assertThat((String)testString).isEqualTo(oldString);
            String newString = StringSerializationTest.deserializeBytes(oldBytes, StringSerializationTest::newReadString);
            Assertions.assertThat((String)testString).isEqualTo(newString);
            String roundtrip = StringSerializationTest.deserializeBytes(newBytes, StringSerializationTest::newReadString);
            Assertions.assertThat((String)testString).isEqualTo(roundtrip);
        }
    }

    @Test
    void testNullValues() throws IOException {
        String[] testStrings = new String[]{"a", null, "", null, "bcd", null, "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", null, "", null, "non-empty"};
        StringSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testLongValues() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000)};
        StringSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testMixedValues() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), null, StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), null, "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", null};
        StringSerializationTest.testSerialization(testStrings);
    }

    @Test
    void testBinaryCopyOfLongStrings() throws IOException {
        String[] testStrings = new String[]{StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), null, StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), null, "", StringUtils.getRandomString((Random)this.rnd, (int)10000, (int)0x200000), "", null};
        StringSerializationTest.testCopy(testStrings);
    }

    public static byte[] serializeBytes(String value, BiConsumer<String, DataOutput> writer) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(buffer);
        writer.accept(value, stream);
        stream.close();
        return buffer.toByteArray();
    }

    public static String deserializeBytes(byte[] value, Function<DataInput, String> reader) throws IOException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(value);
        DataInputStream stream = new DataInputStream(buffer);
        String result = reader.apply(stream);
        stream.close();
        return result;
    }

    public static void testSerialization(String[] values) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputStream serializer = new DataOutputStream(baos);
        for (String value : values) {
            StringValue.writeString((CharSequence)value, (DataOutput)serializer);
        }
        serializer.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream deserializer = new DataInputStream(bais);
        int num = 0;
        while (deserializer.available() > 0) {
            String deser = StringValue.readString((DataInput)deserializer);
            Assertions.assertThat((String)values[num]).isEqualTo(deser);
            ++num;
        }
        Assertions.assertThat((Object[])values).hasSize(num);
    }

    public static void testCopy(String[] values) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputStream serializer = new DataOutputStream(baos);
        for (String value : values) {
            StringValue.writeString((CharSequence)value, (DataOutput)serializer);
        }
        serializer.close();
        baos.close();
        ByteArrayInputStream sourceInput = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream source = new DataInputStream(sourceInput);
        ByteArrayOutputStream targetOutput = new ByteArrayOutputStream(4096);
        DataOutputStream target = new DataOutputStream(targetOutput);
        for (int i = 0; i < values.length; ++i) {
            StringValue.copyString((DataInput)source, (DataOutput)target);
        }
        ByteArrayInputStream validateInput = new ByteArrayInputStream(targetOutput.toByteArray());
        DataInputStream validate = new DataInputStream(validateInput);
        int num = 0;
        while (validate.available() > 0) {
            String deser = StringValue.readString((DataInput)validate);
            Assertions.assertThat((String)values[num]).isEqualTo(deser);
            ++num;
        }
        Assertions.assertThat((Object[])values).hasSize(num);
    }

    private static String oldReadString(DataInput in) {
        try {
            int len = in.readUnsignedByte();
            if (len == 0) {
                return null;
            }
            if (len >= 128) {
                int curr;
                int shift = 7;
                len &= 0x7F;
                while ((curr = in.readUnsignedByte()) >= 128) {
                    len |= (curr & 0x7F) << shift;
                    shift += 7;
                }
                len |= curr << shift;
            }
            char[] data = new char[--len];
            for (int i = 0; i < len; ++i) {
                int curr;
                int c = in.readUnsignedByte();
                if (c < 128) {
                    data[i] = (char)c;
                    continue;
                }
                int shift = 7;
                c &= 0x7F;
                while ((curr = in.readUnsignedByte()) >= 128) {
                    c |= (curr & 0x7F) << shift;
                    shift += 7;
                }
                data[i] = (char)(c |= curr << shift);
            }
            return new String(data, 0, len);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void oldWriteString(CharSequence cs, DataOutput out) {
        try {
            if (cs != null) {
                int lenToWrite = cs.length() + 1;
                if (lenToWrite < 0) {
                    throw new IllegalArgumentException("CharSequence is too long.");
                }
                while (lenToWrite >= 128) {
                    out.write(lenToWrite | 0x80);
                    lenToWrite >>>= 7;
                }
                out.write(lenToWrite);
                for (int i = 0; i < cs.length(); ++i) {
                    int c;
                    for (c = cs.charAt(i); c >= 128; c >>>= 7) {
                        out.write(c | 0x80);
                    }
                    out.write(c);
                }
            } else {
                out.write(0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String newReadString(DataInput in) {
        try {
            return StringValue.readString((DataInput)in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void newWriteString(CharSequence cs, DataOutput out) {
        try {
            StringValue.writeString((CharSequence)cs, (DataOutput)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

