/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowUtilsTest {
    RowUtilsTest() {
    }

    @Test
    void testCompareRowsUnordered() {
        List<Row> originalList = Arrays.asList(Row.of((Object[])new Object[]{"a", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, true}));
        List<Row> list = Arrays.asList(Row.of((Object[])new Object[]{"a", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, true}));
        Assertions.assertThat((boolean)RowUtils.compareRows(originalList, list, (boolean)false)).isTrue();
        list = Arrays.asList(Row.of((Object[])new Object[]{"a", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, true}), Row.of((Object[])new Object[]{"b", 12, false}));
        Assertions.assertThat((boolean)RowUtils.compareRows(originalList, list, (boolean)false)).isFalse();
        list = Arrays.asList(Row.of((Object[])new Object[]{"a", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, true}), Row.of((Object[])new Object[]{"b", 12, false}));
        Assertions.assertThat((boolean)RowUtils.compareRows(originalList, list, (boolean)true)).isTrue();
        list = Arrays.asList(Row.of((Object[])new Object[]{"a", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, false}), Row.of((Object[])new Object[]{"b", 12, true}), Row.of((Object[])new Object[]{"b", 12, true}));
        Assertions.assertThat((boolean)RowUtils.compareRows(originalList, list, (boolean)true)).isFalse();
    }
}

