/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.RecordTest;
import org.apache.flink.types.Value;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RecordITCase {
    private static final long SEED = 354144423270432543L;
    private final Random rand = new Random(354144423270432543L);
    private DataInputView in;
    private DataOutputView out;

    RecordITCase() {
    }

    @BeforeEach
    void setUp() throws Exception {
        PipedInputStream pipedInput = new PipedInputStream(0x2000000);
        this.in = new DataInputViewStreamWrapper((InputStream)pipedInput);
        this.out = new DataOutputViewStreamWrapper((OutputStream)new PipedOutputStream(pipedInput));
    }

    @Test
    void massiveRandomBlackBoxTests() throws Exception {
        Value[] fields;
        int i;
        for (i = 0; i < 100000; ++i) {
            fields = RecordTest.createRandomValues(this.rand, 0, 32);
            RecordTest.blackboxTestRecordWithValues(fields, this.rand, this.in, this.out);
        }
        for (i = 0; i < 2000; ++i) {
            fields = RecordTest.createRandomValues(this.rand, 20, 200);
            RecordTest.blackboxTestRecordWithValues(fields, this.rand, this.in, this.out);
        }
        for (i = 0; i < 200; ++i) {
            fields = RecordTest.createRandomValues(this.rand, 500, 2000);
            RecordTest.blackboxTestRecordWithValues(fields, this.rand, this.in, this.out);
        }
    }
}

