/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrimitiveDataTypeTest {
    private PipedInputStream in;
    private PipedOutputStream out;
    private DataInputView mIn;
    private DataOutputView mOut;

    PrimitiveDataTypeTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.in = new PipedInputStream(1000);
        this.out = new PipedOutputStream(this.in);
        this.mIn = new DataInputViewStreamWrapper((InputStream)this.in);
        this.mOut = new DataOutputViewStreamWrapper((OutputStream)this.out);
    }

    @Test
    void testIntValue() throws IOException {
        IntValue int0 = new IntValue(10);
        Assertions.assertThat((int)int0.getValue()).isEqualTo(10);
        IntValue int1 = new IntValue(10);
        IntValue int2 = new IntValue(-10);
        IntValue int3 = new IntValue(20);
        Assertions.assertThat((Comparable)int0).isEqualByComparingTo((Comparable)int0);
        Assertions.assertThat((Comparable)int0).isEqualByComparingTo((Comparable)int1);
        Assertions.assertThat((int)int0.compareTo(int2)).isOne();
        Assertions.assertThat((int)int0.compareTo(int3)).isEqualTo(-1);
        int0.write(this.mOut);
        int2.write(this.mOut);
        int3.write(this.mOut);
        IntValue int1n = new IntValue();
        IntValue int2n = new IntValue();
        IntValue int3n = new IntValue();
        int1n.read(this.mIn);
        int2n.read(this.mIn);
        int3n.read(this.mIn);
        Assertions.assertThat((Comparable)int0).isEqualByComparingTo((Comparable)int1n);
        Assertions.assertThat((int)int1n.getValue()).isEqualTo(int0.getValue());
        Assertions.assertThat((Comparable)int2).isEqualByComparingTo((Comparable)int2n);
        Assertions.assertThat((int)int2n.getValue()).isEqualTo(int2.getValue());
        Assertions.assertThat((Comparable)int3).isEqualByComparingTo((Comparable)int3n);
        Assertions.assertThat((int)int3n.getValue()).isEqualTo(int3.getValue());
    }

    @Test
    void testDoubleValue() throws IOException {
        DoubleValue double0 = new DoubleValue(10.2);
        Assertions.assertThat((double)double0.getValue()).isCloseTo(10.2, Assertions.within((Double)1.0E-4));
        DoubleValue double1 = new DoubleValue(10.2);
        DoubleValue double2 = new DoubleValue(-10.5);
        DoubleValue double3 = new DoubleValue(20.2);
        Assertions.assertThat((Comparable)double0).isEqualByComparingTo((Comparable)double0);
        Assertions.assertThat((Comparable)double0).isEqualByComparingTo((Comparable)double1);
        Assertions.assertThat((int)double0.compareTo(double2)).isOne();
        Assertions.assertThat((int)double0.compareTo(double3)).isEqualTo(-1);
        double0.write(this.mOut);
        double2.write(this.mOut);
        double3.write(this.mOut);
        DoubleValue double1n = new DoubleValue();
        DoubleValue double2n = new DoubleValue();
        DoubleValue double3n = new DoubleValue();
        double1n.read(this.mIn);
        double2n.read(this.mIn);
        double3n.read(this.mIn);
        Assertions.assertThat((Comparable)double0).isEqualByComparingTo((Comparable)double1n);
        Assertions.assertThat((double)double1n.getValue()).isCloseTo(double0.getValue(), Assertions.within((Double)1.0E-4));
        Assertions.assertThat((Comparable)double2).isEqualByComparingTo((Comparable)double2n);
        Assertions.assertThat((double)double2n.getValue()).isCloseTo(double2.getValue(), Assertions.within((Double)1.0E-4));
        Assertions.assertThat((Comparable)double3).isEqualByComparingTo((Comparable)double3n);
        Assertions.assertThat((double)double3n.getValue()).isCloseTo(double3.getValue(), Assertions.within((Double)1.0E-4));
    }

    @Test
    void testStringValue() throws IOException {
        StringValue string0 = new StringValue((CharSequence)"This is a test");
        StringValue stringThis = new StringValue((CharSequence)"This");
        StringValue stringIsA = new StringValue((CharSequence)"is a");
        Assertions.assertThat((Object)string0).hasToString("This is a test");
        StringValue string1 = new StringValue((CharSequence)"This is a test");
        StringValue string2 = new StringValue((CharSequence)"This is a tesa");
        StringValue string3 = new StringValue((CharSequence)"This is a tesz");
        StringValue string4 = new StringValue((CharSequence)"\u00dcnlaut \u00dftring \u00b5 avec \u00e9 y \u00a2");
        CharSequence chars5 = string1.subSequence(0, 4);
        StringValue string5 = (StringValue)chars5;
        StringValue string6 = (StringValue)string0.subSequence(0, string0.length());
        StringValue string7 = (StringValue)string0.subSequence(5, 9);
        StringValue string8 = (StringValue)string0.subSequence(0, 0);
        Assertions.assertThatComparable((Comparable)string0).isEqualByComparingTo((Object)string0);
        Assertions.assertThatComparable((Comparable)string1).isEqualByComparingTo((Object)string0);
        Assertions.assertThatComparable((Comparable)string0).isGreaterThan((Object)string2);
        Assertions.assertThatComparable((Comparable)string0).isLessThan((Object)string3);
        Assertions.assertThat((CharSequence)chars5).isEqualTo((Object)stringThis);
        Assertions.assertThatComparable((Comparable)string5).isEqualByComparingTo((Object)stringThis);
        Assertions.assertThatComparable((Comparable)string6).isEqualByComparingTo((Object)string0);
        Assertions.assertThatComparable((Comparable)string7).isEqualByComparingTo((Object)stringIsA);
        string7.setValue((CharSequence)"This is a test");
        Assertions.assertThatComparable((Comparable)stringIsA).isGreaterThan((Object)string7);
        Assertions.assertThatComparable((Comparable)string7).isEqualByComparingTo((Object)string0);
        string7.setValue((CharSequence)"is a");
        Assertions.assertThatComparable((Comparable)string7).isEqualByComparingTo((Object)stringIsA);
        Assertions.assertThatComparable((Comparable)string0).isLessThan((Object)string7);
        Assertions.assertThat((Object)string7).hasSameHashCodeAs((Object)stringIsA);
        Assertions.assertThat((int)string7.length()).isEqualTo(4);
        Assertions.assertThat((String)string7.getValue()).isEqualTo("is a");
        Assertions.assertThat((int)string8.length()).isZero();
        Assertions.assertThat((Object)string8).hasToString("");
        Assertions.assertThat((char)string7.charAt(1)).isEqualTo('s');
        Assertions.assertThatThrownBy(() -> string7.charAt(5)).isInstanceOf(IndexOutOfBoundsException.class);
        string0.write(this.mOut);
        string4.write(this.mOut);
        string2.write(this.mOut);
        string3.write(this.mOut);
        string7.write(this.mOut);
        StringValue string1n = new StringValue();
        StringValue string2n = new StringValue();
        StringValue string3n = new StringValue();
        StringValue string4n = new StringValue();
        StringValue string7n = new StringValue();
        string1n.read(this.mIn);
        string4n.read(this.mIn);
        string2n.read(this.mIn);
        string3n.read(this.mIn);
        string7n.read(this.mIn);
        Assertions.assertThatComparable((Comparable)string1n).isEqualByComparingTo((Object)string0);
        Assertions.assertThat((Object)string1n).hasToString(string0.toString());
        Assertions.assertThatComparable((Comparable)string4n).isEqualByComparingTo((Object)string4);
        Assertions.assertThat((Object)string4n).hasToString(string4.toString());
        Assertions.assertThatComparable((Comparable)string2n).isEqualByComparingTo((Object)string2);
        Assertions.assertThat((Object)string2n).hasToString(string2.toString());
        Assertions.assertThatComparable((Comparable)string3n).isEqualByComparingTo((Object)string3);
        Assertions.assertThat((Object)string3n).hasToString(string3.toString());
        Assertions.assertThatComparable((Comparable)string7n).isEqualByComparingTo((Object)string7);
        Assertions.assertThat((Object)string7n).hasToString(string7.toString());
        Assertions.assertThatThrownBy(() -> string7n.charAt(5)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testPactNull() throws IOException {
        int i;
        NullValue pn1 = new NullValue();
        NullValue pn2 = new NullValue();
        Assertions.assertThat((Comparable)pn1).isEqualTo((Object)pn2);
        Assertions.assertThat((Comparable)pn2).isEqualTo((Object)pn1);
        Assertions.assertThat((Comparable)pn1).isNotNull();
        NullValue pn = new NullValue();
        int numWrites = 13;
        for (i = 0; i < 13; ++i) {
            pn.write(this.mOut);
        }
        for (i = 0; i < 13; ++i) {
            pn.read(this.mIn);
        }
        Assertions.assertThat((int)this.in.available()).isZero();
    }
}

