/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CopyableValueTest {
    CopyableValueTest() {
    }

    @Test
    void testCopy() {
        CopyableValue[] value_types;
        for (CopyableValue type : value_types = new CopyableValue[]{new BooleanValue(true), new ByteValue(42), new CharValue('q'), new DoubleValue(Math.PI), new FloatValue((float)Math.PI), new IntValue(42), new LongValue(42L), new NullValue(), new ShortValue(42), new StringValue((CharSequence)"QED")}) {
            Assertions.assertThat((Object)type.copy()).isEqualTo((Object)type);
        }
    }

    @Test
    void testCopyTo() {
        BooleanValue boolean_from = new BooleanValue(true);
        BooleanValue boolean_to = new BooleanValue(false);
        boolean_from.copyTo(boolean_to);
        Assertions.assertThat((Comparable)boolean_to).isEqualTo((Object)boolean_from);
        ByteValue byte_from = new ByteValue(3);
        ByteValue byte_to = new ByteValue(7);
        byte_from.copyTo(byte_to);
        Assertions.assertThat((Comparable)byte_to).isEqualTo((Object)byte_from);
        CharValue char_from = new CharValue('\u03b1');
        CharValue char_to = new CharValue('\u03c9');
        char_from.copyTo(char_to);
        Assertions.assertThat((Comparable)char_to).isEqualTo((Object)char_from);
        DoubleValue double_from = new DoubleValue(Math.E);
        DoubleValue double_to = new DoubleValue(0.0);
        double_from.copyTo(double_to);
        Assertions.assertThat((Comparable)double_to).isEqualTo((Object)double_from);
        FloatValue float_from = new FloatValue((float)Math.E);
        FloatValue float_to = new FloatValue(1.4142135f);
        float_from.copyTo(float_to);
        Assertions.assertThat((Comparable)float_to).isEqualTo((Object)float_from);
        IntValue int_from = new IntValue(8191);
        IntValue int_to = new IntValue(131071);
        int_from.copyTo(int_to);
        Assertions.assertThat((Comparable)int_to).isEqualTo((Object)int_from);
        LongValue long_from = new LongValue(524287L);
        LongValue long_to = new LongValue(Integer.MAX_VALUE);
        long_from.copyTo(long_to);
        Assertions.assertThat((Comparable)long_to).isEqualTo((Object)long_from);
        NullValue null_from = new NullValue();
        NullValue null_to = new NullValue();
        null_from.copyTo(null_to);
        Assertions.assertThat((Comparable)null_to).isEqualTo((Object)null_from);
        ShortValue short_from = new ShortValue(31);
        ShortValue short_to = new ShortValue(127);
        short_from.copyTo(short_to);
        Assertions.assertThat((Comparable)short_to).isEqualTo((Object)short_from);
        StringValue string_from = new StringValue((CharSequence)"2305843009213693951");
        StringValue string_to = new StringValue((CharSequence)"618970019642690137449562111");
        string_from.copyTo(string_to);
        Assertions.assertThat((Object)string_to).isEqualTo((Object)string_from);
    }
}

