/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Date;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BasicTypeInfoTest {
    static final Class<?>[] CLASSES = new Class[]{String.class, Integer.class, Boolean.class, Byte.class, Short.class, Long.class, Float.class, Double.class, Character.class, Date.class, Void.class, BigInteger.class, BigDecimal.class, Instant.class};

    BasicTypeInfoTest() {
    }

    @Test
    void testBasicTypeInfoEquality() {
        for (Class<?> clazz : CLASSES) {
            BasicTypeInfo tpeInfo1 = BasicTypeInfo.getInfoFor(clazz);
            BasicTypeInfo tpeInfo2 = BasicTypeInfo.getInfoFor(clazz);
            Assertions.assertThat((Object)tpeInfo2).isEqualTo((Object)tpeInfo1);
            Assertions.assertThat((Object)tpeInfo2).hasSameHashCodeAs((Object)tpeInfo1);
        }
    }

    @Test
    void testBasicTypeInfoInequality() {
        for (Class<?> clazz1 : CLASSES) {
            for (Class<?> clazz2 : CLASSES) {
                if (clazz1.equals(clazz2)) continue;
                BasicTypeInfo tpeInfo1 = BasicTypeInfo.getInfoFor(clazz1);
                BasicTypeInfo tpeInfo2 = BasicTypeInfo.getInfoFor(clazz2);
                Assertions.assertThat((Object)tpeInfo2).isNotEqualTo((Object)tpeInfo1);
            }
        }
    }
}

