/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class LongType
implements SerializationTestType {
    private long value;

    public LongType() {
        this.value = 0L;
    }

    private LongType(long value) {
        this.value = value;
    }

    @Override
    public LongType getRandom(Random rnd) {
        return new LongType(rnd.nextLong());
    }

    @Override
    public int length() {
        return 8;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readLong();
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongType) {
            LongType other = (LongType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

