/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class FloatType
implements SerializationTestType {
    private float value;

    public FloatType() {
        this.value = 0.0f;
    }

    private FloatType(float value) {
        this.value = value;
    }

    @Override
    public FloatType getRandom(Random rnd) {
        return new FloatType(rnd.nextFloat());
    }

    @Override
    public int length() {
        return 4;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeFloat(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readFloat();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatType) {
            FloatType other = (FloatType)obj;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
        }
        return false;
    }
}

