/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class CharType
implements SerializationTestType {
    private char value;

    public CharType() {
        this.value = '\u0000';
    }

    private CharType(char value) {
        this.value = value;
    }

    @Override
    public CharType getRandom(Random rnd) {
        return new CharType((char)rnd.nextInt(10000));
    }

    @Override
    public int length() {
        return 2;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeChar((int)this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readChar();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharType) {
            CharType other = (CharType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

