/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NoFetchingInputTest {
    NoFetchingInputTest() {
    }

    @Test
    void testDeserializeEmptyObject() {
        EmptyObjectSerializer emptyObjectSerializer = new EmptyObjectSerializer();
        ByteBufferOutput output = new ByteBufferOutput(1000);
        emptyObjectSerializer.write(null, (Output)output, new Object());
        NoFetchingInput input = new NoFetchingInput((InputStream)new ByteArrayInputStream(output.toBytes()));
        Object deserialized = emptyObjectSerializer.read(null, (Input)input, Object.class);
        Assertions.assertThat((Object)deserialized).isExactlyInstanceOf(Object.class);
    }

    public static class EmptyObjectSerializer
    extends Serializer<Object> {
        public void write(Kryo kryo, Output output, Object mes) {
            byte[] ser = new byte[]{};
            output.writeInt(ser.length, true);
            output.writeBytes(ser);
        }

        public Object read(Kryo kryo, Input input, Class<? extends Object> pbClass) {
            try {
                int size = input.readInt(true);
                Assertions.assertThat((int)size).isZero();
                byte[] barr = new byte[size];
                input.readBytes(barr);
                return new Object();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create " + pbClass, e);
            }
        }
    }
}

