/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileStatus;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.util.Preconditions;

public class TestFileSystem
extends LocalFileSystem {
    public static final String SCHEME = "test";
    private static final AtomicInteger streamOpenCounter = new AtomicInteger(0);
    private static final Map<Path, Integer> currentUnclosedOutputStream = new ConcurrentHashMap<Path, Integer>();

    public static int getNumtimeStreamOpened() {
        return streamOpenCounter.get();
    }

    public static void resetStreamOpenCounter() {
        streamOpenCounter.set(0);
    }

    public static int getNumberOfUnclosedOutputStream(Path path) {
        return currentUnclosedOutputStream.getOrDefault(path, 0);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        streamOpenCounter.incrementAndGet();
        return super.open(f, bufferSize);
    }

    public FSDataInputStream open(Path f) throws IOException {
        streamOpenCounter.incrementAndGet();
        return super.open(f);
    }

    public FSDataOutputStream create(Path filePath, FileSystem.WriteMode overwrite) throws IOException {
        currentUnclosedOutputStream.compute(filePath, (k, v) -> v == null ? 1 : v + 1);
        LocalDataOutputStream stream = (LocalDataOutputStream)super.create(filePath, overwrite);
        return new TestOutputStream(stream, filePath);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LocalFileStatus status = (LocalFileStatus)super.getFileStatus(f);
        return new LocalFileStatus(status.getFile(), (FileSystem)this);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        FileStatus[] stati = super.listStatus(f);
        LocalFileStatus[] newStati = new LocalFileStatus[stati.length];
        for (int i = 0; i < stati.length; ++i) {
            newStati[i] = new LocalFileStatus(((LocalFileStatus)stati[i]).getFile(), (FileSystem)this);
        }
        return newStati;
    }

    public URI getUri() {
        return URI.create("test:///");
    }

    public static final class TestFileSystemFactory
    implements FileSystemFactory {
        public String getScheme() {
            return TestFileSystem.SCHEME;
        }

        public FileSystem create(URI fsUri) throws IOException {
            return new TestFileSystem();
        }
    }

    private static final class TestOutputStream
    extends FSDataOutputStream {
        private final LocalDataOutputStream stream;
        private final Path path;

        private TestOutputStream(LocalDataOutputStream stream, Path path) {
            this.stream = stream;
            this.path = path;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void sync() throws IOException {
            this.stream.sync();
        }

        public void close() throws IOException {
            currentUnclosedOutputStream.compute(this.path, (k, v) -> (Integer)Preconditions.checkNotNull((Object)v) == 1 ? null : Integer.valueOf(v - 1));
            this.stream.close();
        }
    }
}

