/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.util.function.Supplier;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderUtilsTest {
    @Test
    public void testObjectFromNewClassLoaderObject() throws Exception {
        ClassLoaderUtilsTest.testObjectFromNewClassLoaderObject(ClassLoaderUtils::createSerializableObjectFromNewClassLoader);
    }

    @Test
    public void testObjectFromNewClassLoaderClassLoaders() throws Exception {
        ClassLoaderUtilsTest.testObjectFromNewClassLoaderClassLoaders(ClassLoaderUtils::createSerializableObjectFromNewClassLoader);
    }

    @Test
    public void testExceptionObjectFromNewClassLoaderObject() throws Exception {
        ClassLoaderUtilsTest.testObjectFromNewClassLoaderObject(ClassLoaderUtils::createExceptionObjectFromNewClassLoader);
    }

    @Test
    public void testExceptionObjectFromNewClassLoaderClassLoaders() throws Exception {
        ClassLoaderUtilsTest.testObjectFromNewClassLoaderClassLoaders(ClassLoaderUtils::createExceptionObjectFromNewClassLoader);
    }

    private static <X> void testObjectFromNewClassLoaderObject(Supplier<ClassLoaderUtils.ObjectAndClassLoader<X>> supplier) {
        ClassLoaderUtils.ObjectAndClassLoader<X> objectAndClassLoader = supplier.get();
        X o = objectAndClassLoader.getObject();
        Assert.assertNotEquals((Object)ClassLoader.getSystemClassLoader(), (Object)o.getClass().getClassLoader());
        try {
            Class.forName(o.getClass().getName());
            Assert.fail((String)"should not be able to load class from the system class loader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static <X> void testObjectFromNewClassLoaderClassLoaders(Supplier<ClassLoaderUtils.ObjectAndClassLoader<X>> supplier) {
        ClassLoaderUtils.ObjectAndClassLoader<X> objectAndClassLoader = supplier.get();
        Assert.assertNotEquals((Object)ClassLoader.getSystemClassLoader(), (Object)objectAndClassLoader.getClassLoader());
        Assert.assertEquals((Object)ClassLoader.getSystemClassLoader(), (Object)objectAndClassLoader.getClassLoader().getParent());
    }
}

