/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.management.jmx;

import java.lang.management.ManagementFactory;
import java.util.Optional;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.flink.management.jmx.JMXServer;
import org.apache.flink.management.jmx.JMXService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JMXServerTest {
    JMXServerTest() {
    }

    @BeforeEach
    void setUp() {
        JMXService.startInstance((String)"23456-23466");
    }

    @AfterEach
    void tearDown() throws Exception {
        JMXService.stopInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testJMXServiceRegisterMBean() throws Exception {
        TestObject testObject = new TestObject();
        ObjectName testObjectName = new ObjectName("org.apache.flink.management", "key", "value");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Optional server = JMXService.getInstance();
            Assertions.assertThat((Optional)server).isPresent();
            mBeanServer.registerMBean(testObject, testObjectName);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost:" + ((JMXServer)server.get()).getPort() + "/jndi/rmi://localhost:" + ((JMXServer)server.get()).getPort() + "/jmxrmi");
            JMXConnector jmxConn = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbeanConnConn = jmxConn.getMBeanServerConnection();
            Assertions.assertThat((int)((Integer)mbeanConnConn.getAttribute(testObjectName, "Foo"))).isOne();
            mBeanServer.unregisterMBean(testObjectName);
            Assertions.assertThatThrownBy(() -> mbeanConnConn.getAttribute(testObjectName, "Foo")).isInstanceOf(InstanceNotFoundException.class);
        }
        finally {
            JMXService.stopInstance();
        }
    }

    public static class TestObject
    implements TestObjectMBean {
        private final int foo = 1;

        @Override
        public int getFoo() {
            return 1;
        }
    }

    public static interface TestObjectMBean {
        public int getFoo();
    }
}

