/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.core.plugin.DirectoryBasedPluginFinder;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginFinder;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DirectoryBasedPluginFinderTest {
    @TempDir
    private static Path tempFolder;

    DirectoryBasedPluginFinderTest() {
    }

    @Test
    void createPluginDescriptorsForDirectory() throws Exception {
        File rootFolder = TempDirUtils.newFolder((Path)tempFolder);
        DirectoryBasedPluginFinder descriptorsFactory = new DirectoryBasedPluginFinder(rootFolder.toPath());
        Collection actual = descriptorsFactory.findPlugins();
        Assertions.assertThat((Collection)actual).isEmpty();
        List subDirs = Stream.of("A", "B", "C").map(s -> new File(rootFolder, (String)s)).collect(Collectors.toList());
        for (File subDir : subDirs) {
            Preconditions.checkState((boolean)subDir.mkdirs());
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PluginFinder)descriptorsFactory).findPlugins()).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(IOException.class);
        for (File subDir : subDirs) {
            Preconditions.checkState((boolean)new File(subDir, "ignore-test.zip").createNewFile());
            Preconditions.checkState((boolean)new File(subDir, "ignore-dir").mkdirs());
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PluginFinder)descriptorsFactory).findPlugins()).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(IOException.class);
        ArrayList<PluginDescriptor> expected = new ArrayList<PluginDescriptor>(3);
        for (int i = 0; i < subDirs.size(); ++i) {
            File subDir = (File)subDirs.get(i);
            URL[] jarURLs = new URL[i + 1];
            for (int j = 0; j <= i; ++j) {
                File file = new File(subDir, "jar-file-" + j + ".jar");
                Preconditions.checkState((boolean)file.createNewFile());
                jarURLs[j] = file.toURI().toURL();
            }
            Arrays.sort(jarURLs, Comparator.comparing(URL::toString));
            expected.add(new PluginDescriptor(subDir.getName(), jarURLs, new String[0]));
        }
        actual = descriptorsFactory.findPlugins();
        Assertions.assertThat((boolean)this.equalsIgnoreOrder(expected, new ArrayList<PluginDescriptor>(actual))).isTrue();
    }

    private boolean equalsIgnoreOrder(List<PluginDescriptor> a, List<PluginDescriptor> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Comparator<PluginDescriptor> comparator = Comparator.comparing(PluginDescriptor::getPluginId);
        a.sort(comparator);
        b.sort(comparator);
        Iterator<PluginDescriptor> iterA = a.iterator();
        Iterator<PluginDescriptor> iterB = b.iterator();
        while (iterA.hasNext()) {
            if (DirectoryBasedPluginFinderTest.equals(iterA.next(), iterB.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(@Nonnull PluginDescriptor a, @Nonnull PluginDescriptor b) {
        return a.getPluginId().equals(b.getPluginId()) && Arrays.deepEquals(a.getPluginResourceURLs(), b.getPluginResourceURLs()) && Arrays.deepEquals(a.getLoaderExcludePatterns(), b.getLoaderExcludePatterns());
    }
}

