/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class OnHeapMemorySegmentTest
extends MemorySegmentTestBase {
    OnHeapMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateUnpooledSegment((int)size, (Object)owner);
    }

    @TestTemplate
    void testHeapSegmentSpecifics() {
        byte[] buffer = new byte[411];
        MemorySegment seg = new MemorySegment(buffer, null);
        Assertions.assertThat((boolean)seg.isFreed()).isFalse();
        Assertions.assertThat((boolean)seg.isOffHeap()).isFalse();
        Assertions.assertThat((int)seg.size()).isEqualTo(buffer.length);
        Assertions.assertThat((byte[])seg.getArray()).isSameAs((Object)buffer);
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assertions.assertThat((Comparable)buf2).isNotSameAs((Object)buf1);
        Assertions.assertThat((int)buf1.position()).isOne();
        Assertions.assertThat((int)buf1.limit()).isEqualTo(3);
        Assertions.assertThat((int)buf2.position()).isEqualTo(3);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(7);
    }

    @TestTemplate
    void testReadOnlyByteBufferPut() {
        int i;
        byte[] buffer = new byte[100];
        MemorySegment seg = new MemorySegment(buffer, null);
        String content = "hello world";
        ByteBuffer bb = ByteBuffer.allocate(20);
        bb.put(content.getBytes());
        bb.rewind();
        int offset = 10;
        int numBytes = 5;
        ByteBuffer readOnlyBuf = bb.asReadOnlyBuffer();
        Assertions.assertThat((boolean)readOnlyBuf.isDirect()).isFalse();
        Assertions.assertThat((boolean)readOnlyBuf.hasArray()).isFalse();
        seg.put(offset, readOnlyBuf, numBytes);
        for (i = 0; i < offset; ++i) {
            Assertions.assertThat((byte)buffer[i]).isZero();
        }
        Assertions.assertThat((String)new String(buffer, offset, numBytes)).isEqualTo("hello");
        for (i = offset + numBytes; i < buffer.length; ++i) {
            Assertions.assertThat((byte)buffer[i]).isZero();
        }
    }
}

