/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RefCountedFileWithStreamTest {
    @TempDir
    private static Path tempFolder;

    RefCountedFileWithStreamTest() {
    }

    @Test
    void writeShouldSucceed() throws IOException {
        byte[] content = RefCountedFileWithStreamTest.bytesOf("hello world");
        File newFile = new File(TempDirUtils.newFolder((Path)tempFolder).toPath().toFile(), ".tmp_" + UUID.randomUUID());
        OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
        RefCountedFileWithStream fileUnderTest1 = RefCountedFileWithStream.newFile((File)newFile, (OutputStream)out);
        fileUnderTest1.write(content, 0, content.length);
        fileUnderTest1.closeStream();
        Assertions.assertThat((long)fileUnderTest1.getLength()).isEqualTo((long)content.length);
    }

    @Test
    void closeShouldNotReleaseReference() throws IOException {
        Path path = TempDirUtils.newFolder((Path)tempFolder).toPath();
        this.getClosedRefCountedFileWithContent("hello world", path);
        try (Stream<Path> files = Files.list(path);){
            Assertions.assertThat(files).hasSize(1);
        }
    }

    @Test
    void writeAfterCloseShouldThrowException() {
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> {
            RefCountedFileWithStream fileUnderTest = this.getClosedRefCountedFileWithContent("hello world", TempDirUtils.newFolder((Path)tempFolder).toPath());
            byte[] content = RefCountedFileWithStreamTest.bytesOf("Hello Again");
            fileUnderTest.write(content, 0, content.length);
        });
    }

    @Test
    void flushAfterCloseShouldThrowException() {
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> {
            RefCountedFileWithStream fileUnderTest = this.getClosedRefCountedFileWithContent("hello world", TempDirUtils.newFolder((Path)tempFolder).toPath());
            fileUnderTest.flush();
        });
    }

    private RefCountedFileWithStream getClosedRefCountedFileWithContent(String content, Path tempFolder) throws IOException {
        byte[] content1 = RefCountedFileWithStreamTest.bytesOf(content);
        File newFile = new File(tempFolder.toFile(), ".tmp_" + UUID.randomUUID());
        OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
        RefCountedFileWithStream fileUnderTest = RefCountedFileWithStream.newFile((File)newFile, (OutputStream)out);
        fileUnderTest.write(content1, 0, content1.length);
        fileUnderTest.closeStream();
        return fileUnderTest;
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

