/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.util.WrappingProxy;
import org.apache.flink.util.WrappingProxyUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileSystemTest {
    FileSystemTest() {
    }

    @Test
    void testGet() throws URISyntaxException, IOException {
        String scheme = "file";
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":///test/test")).isInstanceOf(LocalFileSystem.class);
        try {
            FileSystemTest.getFileSystemWithoutSafetyNet(scheme + "://test/test");
        }
        catch (IOException ioe) {
            Assertions.assertThat((String)ioe.getMessage()).startsWith((CharSequence)"Found local file path with authority '");
        }
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":/test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet("/test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet("test/test")).isInstanceOf(LocalFileSystem.class);
    }

    @Test
    void testUnsupportedFS() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemTest.getFileSystemWithoutSafetyNet("unknownfs://authority/")).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("not directly supported").hasMessageContaining("no Hadoop file system to support this scheme");
    }

    @Test
    void testKnownFSWithoutPlugins() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemTest.getFileSystemWithoutSafetyNet("s3://authority/")).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("is directly supported").hasMessageContaining("flink-s3-fs-hadoop").hasMessageContaining("flink-s3-fs-presto").hasMessageNotContaining("no Hadoop file system to support this scheme");
    }

    @Test
    void testKnownFSWithoutPluginsAndException() {
        try {
            Configuration config = new Configuration();
            config.set(CoreOptions.ALLOWED_FALLBACK_FILESYSTEMS, (Object)"s3;wasb");
            FileSystem.initialize((Configuration)config, null);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemTest.getFileSystemWithoutSafetyNet("s3://authority/")).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("File system schemes are supported").hasMessageContaining("flink-s3-fs-hadoop").hasMessageContaining("flink-s3-fs-presto").hasMessageContaining("Please ensure that each plugin is configured properly");
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration(), null);
        }
    }

    private static FileSystem getFileSystemWithoutSafetyNet(String uri) throws URISyntaxException, IOException {
        FileSystem fileSystem = FileSystem.get((URI)new URI(uri));
        if (fileSystem instanceof WrappingProxy) {
            return (FileSystem)WrappingProxyUtil.stripProxy((WrappingProxy)((WrappingProxy)fileSystem));
        }
        return fileSystem;
    }
}

