/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.EntropyInjector;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.OutputStreamAndPath;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.PluginFileSystemFactory;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class EntropyInjectorTest {
    @TempDir
    private static java.nio.file.Path tempFolder;

    EntropyInjectorTest() {
    }

    @Test
    void testEmptyPath() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("test", "ignored");
        Path path = new Path("hdfs://localhost:12345");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)path);
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)path);
    }

    @Test
    void testFullUriNonMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "ignored");
        Path path = new Path("s3://hugo@myawesomehost:55522/path/to/the/file");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)path);
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)path);
    }

    @Test
    void testFullUriMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("s0mek3y", "12345678");
        Path path = new Path("s3://hugo@myawesomehost:55522/path/s0mek3y/the/file");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)new Path("s3://hugo@myawesomehost:55522/path/12345678/the/file"));
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)new Path("s3://hugo@myawesomehost:55522/path/the/file"));
    }

    @Test
    void testPathOnlyNonMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "ignored");
        Path path = new Path("/path/file");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)path);
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)path);
    }

    @Test
    void testPathOnlyMatching() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "xyzz");
        Path path = new Path("/path/_entropy_key_/file");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)new Path("/path/xyzz/file"));
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)new Path("/path/file"));
    }

    @Test
    void testEntropyNotFullSegment() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_entropy_key_", "pqr");
        Path path = new Path("s3://myhost:122/entropy-_entropy_key_-suffix/file");
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)true)).isEqualTo((Object)new Path("s3://myhost:122/entropy-pqr-suffix/file"));
        Assertions.assertThat((Object)EntropyInjector.resolveEntropy((Path)path, (EntropyInjectingFileSystem)efs, (boolean)false)).isEqualTo((Object)new Path("s3://myhost:122/entropy--suffix/file"));
    }

    @Test
    void testCreateEntropyAwarePlainFs() throws Exception {
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "_entropy_/file");
        OutputStreamAndPath out = EntropyInjector.createEntropyAware((FileSystem)LocalFileSystem.getSharedInstance(), (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        out.stream().close();
        Assertions.assertThat((Object)out.path()).isEqualTo((Object)path);
        Assertions.assertThat((File)new File(new File(folder, "_entropy_"), "file")).exists();
    }

    @Test
    void testCreateEntropyAwareEntropyFs() throws Exception {
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "_entropy_/file");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "test-entropy/file");
        TestEntropyInjectingFs fs = new TestEntropyInjectingFs("_entropy_", "test-entropy");
        OutputStreamAndPath out = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        out.stream().close();
        Assertions.assertThat((Object)out.path()).isEqualTo((Object)new Path(Path.fromLocalFile((File)folder), "test-entropy/file"));
        Assertions.assertThat((File)new File(new File(folder, "test-entropy"), "file")).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWithSafetyNet() throws Exception {
        FSDataOutputStream out;
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("__ekey__", "abc");
        FileSystemSafetyNet.initializeSafetyNetForThread();
        FileSystem fs = FileSystemSafetyNet.wrapWithSafetyNetWhenActivated((FileSystem)efs);
        try {
            OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
            out = streamAndPath.stream();
            Assertions.assertThat((Object)streamAndPath.path()).isEqualTo((Object)pathWithEntropy);
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
        Assertions.assertThatThrownBy(() -> {
            out.write(42);
            out.flush();
        }).isInstanceOf(IOException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testClassLoaderFixingFsWithSafeyNet() throws Exception {
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        PluginFileSystemFactory pluginFsFactory = PluginFileSystemFactory.of((FileSystemFactory)new TestFileSystemFactory("__ekey__", "abc"));
        FileSystem testFs = pluginFsFactory.create(URI.create("test"));
        FileSystemSafetyNet.initializeSafetyNetForThread();
        FileSystem fs = FileSystemSafetyNet.wrapWithSafetyNetWhenActivated((FileSystem)testFs);
        try {
            OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)fs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
            Assertions.assertThat((Object)streamAndPath.path()).isEqualTo((Object)pathWithEntropy);
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
    }

    @Test
    void testClassLoaderFixingFsWithoutSafeyNet() throws Exception {
        String entropyKey = "__ekey__";
        String entropyValue = "abc";
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "__ekey__/path/");
        Path pathWithEntropy = new Path(Path.fromLocalFile((File)folder), "abc/path/");
        PluginFileSystemFactory pluginFsFactory = PluginFileSystemFactory.of((FileSystemFactory)new TestFileSystemFactory("__ekey__", "abc"));
        FileSystem testFs = pluginFsFactory.create(URI.create("test"));
        OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)testFs, (Path)path, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        Assertions.assertThat((Object)streamAndPath.path()).isEqualTo((Object)pathWithEntropy);
    }

    @Test
    void testIsEntropyFs() throws Exception {
        String entropyKey = "_test_";
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_test_", "ignored");
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "_test_/path/");
        Assertions.assertThat((boolean)EntropyInjector.isEntropyInjecting((FileSystem)efs, (Path)path)).isTrue();
    }

    @Test
    void testIsEntropyFsWithNullEntropyKey() throws Exception {
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs(null, "ignored");
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Assertions.assertThat((boolean)EntropyInjector.isEntropyInjecting((FileSystem)efs, (Path)Path.fromLocalFile((File)folder))).isFalse();
    }

    @Test
    void testIsEntropyFsPathDoesNotIncludeEntropyKey() throws Exception {
        String entropyKey = "_test_";
        TestEntropyInjectingFs efs = new TestEntropyInjectingFs("_test_", "ignored");
        File folder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Path path = new Path(Path.fromLocalFile((File)folder), "path");
        Assertions.assertThat((boolean)EntropyInjector.isEntropyInjecting((FileSystem)efs, (Path)path)).isFalse();
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    private static class TestFileSystemFactory
    implements FileSystemFactory {
        private final String key;
        private final String entropy;

        TestFileSystemFactory(String key, String entropy) {
            this.key = key;
            this.entropy = entropy;
        }

        public String getScheme() {
            return null;
        }

        public FileSystem create(URI fsUri) {
            return new TestEntropyInjectingFs(this.key, this.entropy);
        }

        private static File newFolder(File root, String ... subDirs) throws IOException {
            String subFolder = String.join((CharSequence)"/", subDirs);
            File result = new File(root, subFolder);
            if (!result.mkdirs()) {
                throw new IOException("Couldn't create folders " + root);
            }
            return result;
        }
    }

    private static final class TestEntropyInjectingFs
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        private final String key;
        private final String entropy;

        TestEntropyInjectingFs(String key, String entropy) {
            this.key = key;
            this.entropy = entropy;
        }

        public String getEntropyInjectionKey() {
            return this.key;
        }

        public String generateEntropy() {
            return this.entropy;
        }

        private static File newFolder(File root, String ... subDirs) throws IOException {
            String subFolder = String.join((CharSequence)"/", subDirs);
            File result = new File(root, subFolder);
            if (!result.mkdirs()) {
                throw new IOException("Couldn't create folders " + root);
            }
            return result;
        }
    }
}

