/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.StructuredOptionsSplitter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StructuredOptionsSplitterTest {
    @Parameter
    private TestSpec testSpec;

    StructuredOptionsSplitterTest() {
    }

    @Parameters(name="testSpec = {0}")
    private static Collection<TestSpec> getSpecs() {
        return Arrays.asList(TestSpec.split("'A;B';C", ';').expect("A;B", "C"), TestSpec.split("'A;B';'C'", ';').expect("A;B", "C"), TestSpec.split("A;B;C", ';').expect("A", "B", "C"), TestSpec.split("'AB''D;B';C", ';').expect("AB'D;B", "C"), TestSpec.split("A'BD;B';C", ';').expect("A'BD", "B'", "C"), TestSpec.split("'AB'D;B;C", ';').expectException("Could not split string. Illegal quoting at position: 3"), TestSpec.split("'A", ';').expectException("Could not split string. Quoting was not closed properly."), TestSpec.split("C;'", ';').expectException("Could not split string. Quoting was not closed properly."), TestSpec.split("\"A;B\";C", ';').expect("A;B", "C"), TestSpec.split("\"A;B\";\"C\"", ';').expect("A;B", "C"), TestSpec.split("A;B;C", ';').expect("A", "B", "C"), TestSpec.split("\"AB\"\"D;B\";C", ';').expect("AB\"D;B", "C"), TestSpec.split("A\"BD;B\";C", ';').expect("A\"BD", "B\"", "C"), TestSpec.split("\"AB\"D;B;C", ';').expectException("Could not split string. Illegal quoting at position: 3"), TestSpec.split("\"A", ';').expectException("Could not split string. Quoting was not closed properly."), TestSpec.split("C;\"", ';').expectException("Could not split string. Quoting was not closed properly."), TestSpec.split("'AB\"D';B;C", ';').expect("AB\"D", "B", "C"), TestSpec.split("'AB\"D;B';C", ';').expect("AB\"D;B", "C"), TestSpec.split("'AB\"''D;B';C", ';').expect("AB\"'D;B", "C"), TestSpec.split("\"AB'D\";B;C", ';').expect("AB'D", "B", "C"), TestSpec.split("\"AB'D;B\";C", ';').expect("AB'D;B", "C"), TestSpec.split("\"AB'\"\"D;B\";C", ';').expect("AB'\"D;B", "C"), TestSpec.split("'A,B',C", ',').expect("A,B", "C"), TestSpec.split("A,B,C", ',').expect("A", "B", "C"), TestSpec.split("   'A;B'    ;   C   ", ';').expect("A;B", "C"), TestSpec.split("   A;B    ;   C   ", ';').expect("A", "B", "C"), TestSpec.split("'A;B'    ;C A", ';').expect("A;B", "C A"), TestSpec.split("' A    ;B'    ;'   C'", ';').expect(" A    ;B", "   C"));
    }

    @TestTemplate
    void testParse() {
        Optional<String> expectedException = this.testSpec.getExpectedException();
        if (expectedException.isPresent()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> StructuredOptionsSplitter.splitEscaped((String)this.testSpec.getString(), (char)this.testSpec.getDelimiter())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(expectedException.get());
            return;
        }
        List splits = StructuredOptionsSplitter.splitEscaped((String)this.testSpec.getString(), (char)this.testSpec.getDelimiter());
        Assertions.assertThat((List)splits).isEqualTo(this.testSpec.getExpectedSplits());
    }

    private static class TestSpec {
        private final String string;
        private final char delimiter;
        @Nullable
        private String expectedException = null;
        private List<String> expectedSplits = null;

        private TestSpec(String string, char delimiter) {
            this.string = string;
            this.delimiter = delimiter;
        }

        public static TestSpec split(String string, char delimiter) {
            return new TestSpec(string, delimiter);
        }

        public TestSpec expect(String ... splits) {
            this.expectedSplits = Arrays.asList(splits);
            return this;
        }

        public TestSpec expectException(String message) {
            this.expectedException = message;
            return this;
        }

        public String getString() {
            return this.string;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public Optional<String> getExpectedException() {
            return Optional.ofNullable(this.expectedException);
        }

        public List<String> getExpectedSplits() {
            return this.expectedSplits;
        }

        public String toString() {
            return String.format("str = [ %s ], del = '%s', expected = %s", this.string, Character.valueOf(this.delimiter), this.getExpectedException().map(e -> String.format("Exception(%s)", e)).orElseGet(() -> this.expectedSplits.stream().collect(Collectors.joining("], [", "[", "]"))));
        }
    }
}

