/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FilesystemSchemeConfigTest {
    @TempDir
    private File tempFolder;

    FilesystemSchemeConfigTest() {
    }

    @AfterEach
    void clearFsSettings() {
        FileSystem.initialize((Configuration)new Configuration());
    }

    @Test
    void testDefaultsToLocal() throws Exception {
        URI justPath = new URI(File.createTempFile("junit", null, this.tempFolder).toURI().getPath());
        Assertions.assertThat((String)justPath.getScheme()).isNull();
        FileSystem fs = FileSystem.get((URI)justPath);
        Assertions.assertThat((String)fs.getUri().getScheme()).isEqualTo("file");
    }

    @Test
    void testExplicitlySetToLocal() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)LocalFileSystem.getLocalFsURI().toString());
        FileSystem.initialize((Configuration)conf);
        URI justPath = new URI(File.createTempFile("junit", null, this.tempFolder).toURI().getPath());
        Assertions.assertThat((String)justPath.getScheme()).isNull();
        FileSystem fs = FileSystem.get((URI)justPath);
        Assertions.assertThat((String)fs.getUri().getScheme()).isEqualTo("file");
    }

    @Test
    void testExplicitlySetToOther() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"otherFS://localhost:1234/");
        FileSystem.initialize((Configuration)conf);
        URI justPath = new URI(File.createTempFile("junit", null, this.tempFolder).toURI().getPath());
        Assertions.assertThat((String)justPath.getScheme()).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystem.get((URI)justPath)).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("otherFS");
    }

    @Test
    void testExplicitlyPathTakesPrecedence() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"otherFS://localhost:1234/");
        FileSystem.initialize((Configuration)conf);
        URI pathAndScheme = File.createTempFile("junit", null, this.tempFolder).toURI();
        Assertions.assertThat((String)pathAndScheme.getScheme()).isNotNull();
        FileSystem fs = FileSystem.get((URI)pathAndScheme);
        Assertions.assertThat((String)fs.getUri().getScheme()).isEqualTo("file");
    }
}

