/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DelegatingConfigurationTest {
    DelegatingConfigurationTest() {
    }

    @Test
    void testIfDelegatesImplementAllMethods() throws IllegalArgumentException {
        Method[] confMethods = Configuration.class.getDeclaredMethods();
        Method[] delegateMethods = DelegatingConfiguration.class.getDeclaredMethods();
        for (Method configurationMethod : confMethods) {
            int mod = configurationMethod.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
            boolean hasMethod = false;
            block1: for (Method wrapperMethod : delegateMethods) {
                Class<?>[] configMethodParams;
                Class<?>[] wrapperMethodParams;
                if (!configurationMethod.getName().equals(wrapperMethod.getName()) || (wrapperMethodParams = wrapperMethod.getParameterTypes()).length != (configMethodParams = configurationMethod.getParameterTypes()).length) continue;
                for (int i = 0; i < wrapperMethodParams.length; ++i) {
                    if (wrapperMethodParams[i] != configMethodParams[i]) continue block1;
                }
                hasMethod = true;
                break;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasMethod).as("Configuration method '" + configurationMethod.getName() + "' has not been wrapped correctly in DelegatingConfiguration wrapper", new Object[0])).isTrue();
        }
    }

    @Test
    void testDelegationConfigurationWithNullOrEmptyPrefix() {
        Configuration backingConf = new Configuration();
        backingConf.setValueInternal("test-key", (Object)"value", false);
        Assertions.assertThatThrownBy(() -> new DelegatingConfiguration(backingConf, null)).isInstanceOf(NullPointerException.class);
        DelegatingConfiguration configuration = new DelegatingConfiguration(backingConf, "");
        Assertions.assertThat((Collection)backingConf.keySet()).isEqualTo((Object)configuration.keySet());
    }

    @Test
    void testDelegationConfigurationWithPrefix() {
        String prefix = "pref-";
        String expectedKey = "key";
        Configuration backingConf = new Configuration();
        backingConf.setValueInternal(prefix + expectedKey, (Object)"value", false);
        DelegatingConfiguration configuration = new DelegatingConfiguration(backingConf, prefix);
        Set keySet = configuration.keySet();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)keySet).hasSize(1)).containsExactly((Object[])new String[]{expectedKey});
        backingConf = new Configuration();
        backingConf.setValueInternal("test-key", (Object)"value", false);
        configuration = new DelegatingConfiguration(backingConf, prefix);
        Assertions.assertThat((Collection)configuration.keySet()).isEmpty();
    }

    @Test
    void testDelegationConfigurationToMapConsistentWithAddAllToProperties() {
        Configuration conf = new Configuration();
        conf.setString("k0", "v0");
        conf.setString("prefix.k1", "v1");
        conf.setString("prefix.prefix.k2", "v2");
        conf.setString("k3.prefix.prefix.k3", "v3");
        DelegatingConfiguration dc = new DelegatingConfiguration(conf, "prefix.");
        Properties properties = new Properties();
        dc.addAllToProperties(properties);
        Map map = dc.toMap();
        Properties mapProperties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            mapProperties.put(entry.getKey(), entry.getValue());
        }
        Assertions.assertThat((Map)mapProperties).isEqualTo((Object)properties);
    }

    @Test
    void testSetReturnsDelegatingConfiguration() {
        Configuration conf = new Configuration();
        DelegatingConfiguration delegatingConf = new DelegatingConfiguration(conf, "prefix.");
        Assertions.assertThat((Object)delegatingConf.set(CoreOptions.DEFAULT_PARALLELISM, (Object)1)).isSameAs((Object)delegatingConf);
    }

    @Test
    void testGetWithOverrideDefault() {
        Configuration original = new Configuration();
        DelegatingConfiguration delegatingConf = new DelegatingConfiguration(original, "prefix.");
        ConfigOption integerOption = ConfigOptions.key((String)"integer.key").intType().noDefaultValue();
        original.set(integerOption, (Object)1);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption, (Object)2))).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption, (Object)2))).isEqualTo(2);
        delegatingConf.set(integerOption, (Object)3);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption, (Object)2))).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption, (Object)2))).isEqualTo(3);
        ConfigOption floatOption = ConfigOptions.key((String)"float.key").floatType().noDefaultValue();
        original.set(floatOption, (Object)Float.valueOf(4.0f));
        Assertions.assertThat((Float)((Float)delegatingConf.get(floatOption, (Object)Float.valueOf(5.0f)))).isEqualTo(5.0f);
        delegatingConf.set(floatOption, (Object)Float.valueOf(6.0f));
        Assertions.assertThat((Float)((Float)delegatingConf.get(floatOption, (Object)Float.valueOf(5.0f)))).isEqualTo(6.0f);
        ConfigOption doubleOption = ConfigOptions.key((String)"double.key").doubleType().noDefaultValue();
        original.set(doubleOption, (Object)7.0);
        Assertions.assertThat((Double)((Double)delegatingConf.get(doubleOption, (Object)8.0))).isEqualTo(8.0);
        delegatingConf.set(doubleOption, (Object)9.0);
        Assertions.assertThat((Double)((Double)delegatingConf.get(doubleOption, (Object)8.0))).isEqualTo(9.0);
        ConfigOption longOption = ConfigOptions.key((String)"long.key").longType().noDefaultValue();
        original.set(longOption, (Object)10L);
        Assertions.assertThat((Long)((Long)delegatingConf.get(longOption, (Object)11L))).isEqualTo(11L);
        delegatingConf.set(longOption, (Object)12L);
        Assertions.assertThat((Long)((Long)delegatingConf.get(longOption, (Object)11L))).isEqualTo(12L);
        ConfigOption booleanOption = ConfigOptions.key((String)"boolean.key").booleanType().noDefaultValue();
        original.set(booleanOption, (Object)false);
        Assertions.assertThat((Boolean)((Boolean)delegatingConf.get(booleanOption, (Object)true))).isEqualTo(true);
        delegatingConf.set(booleanOption, (Object)false);
        Assertions.assertThat((Boolean)((Boolean)delegatingConf.get(booleanOption, (Object)true))).isEqualTo(false);
    }

    @Test
    void testRemoveKeyOrConfig() {
        Configuration original = new Configuration();
        DelegatingConfiguration delegatingConf = new DelegatingConfiguration(original, "prefix.");
        ConfigOption integerOption = ConfigOptions.key((String)"integer.key").intType().noDefaultValue();
        delegatingConf.set(integerOption, (Object)0);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption))).isZero();
        delegatingConf.removeConfig(integerOption);
        Assertions.assertThat((Optional)delegatingConf.getOptional(integerOption)).isEmpty();
        delegatingConf.set(integerOption, (Object)0);
        Assertions.assertThat((Integer)((Integer)delegatingConf.get(integerOption, (Object)-1))).isZero();
        delegatingConf.removeKey(integerOption.key());
        Assertions.assertThat((Optional)delegatingConf.getOptional(integerOption)).isEmpty();
    }
}

