/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Collections;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class ConfigurationParsingInvalidFormatsTest {
    @Parameter
    private ConfigOption<?> option;
    @Parameter(value=1)
    private String invalidString;

    ConfigurationParsingInvalidFormatsTest() {
    }

    @Parameters(name="option = {0}, invalidString = {1}")
    private static Object[][] getSpecs() {
        return new Object[][]{{ConfigOptions.key((String)"int").intType().defaultValue((Object)1), "ABC"}, {ConfigOptions.key((String)"long").longType().defaultValue((Object)1L), "ABC"}, {ConfigOptions.key((String)"float").floatType().defaultValue((Object)Float.valueOf(1.0f)), "ABC"}, {ConfigOptions.key((String)"double").doubleType().defaultValue((Object)1.0), "ABC"}, {ConfigOptions.key((String)"boolean").booleanType().defaultValue((Object)true), "ABC"}, {ConfigOptions.key((String)"memory").memoryType().defaultValue((Object)MemorySize.parse((String)"1kB")), "ABC"}, {ConfigOptions.key((String)"duration").durationType().defaultValue((Object)Duration.ofSeconds(1L)), "ABC"}, {ConfigOptions.key((String)"enum").enumType(TestEnum.class).defaultValue((Object)TestEnum.ENUM1), "ABC"}, {ConfigOptions.key((String)"map").mapType().defaultValue(Collections.emptyMap()), "ABC"}, {ConfigOptions.key((String)"list<int>").intType().asList().defaultValues((Object[])new Integer[]{1, 2}), "A;B;C"}, {ConfigOptions.key((String)"list<string>").stringType().asList().defaultValues((Object[])new String[]{"A"}), "'A;B;C"}};
    }

    @TestTemplate
    void testInvalidStringParsingWithGetOptional() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Configuration configuration = new Configuration();
            configuration.setString(this.option.key(), this.invalidString);
            configuration.getOptional(this.option);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(String.format("Could not parse value '%s' for key '%s'", this.invalidString, this.option.key()));
    }

    @TestTemplate
    void testInvalidStringParsingWithGet() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Configuration configuration = new Configuration();
            configuration.setString(this.option.key(), this.invalidString);
            configuration.get(this.option);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(String.format("Could not parse value '%s' for key '%s'", this.invalidString, this.option.key()));
    }

    private static enum TestEnum {
        ENUM1,
        ENUM2;

    }
}

