/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.flink.configuration.ConfigurationFileMigrationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ConfigurationFileMigrationUtilsTest {
    @TempDir
    private File tmpDir;

    @Test
    void testConfigurationWithLegacyYAML() throws FileNotFoundException {
        File confFile = new File(this.tmpDir, "flink-conf.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("###########################");
            pw.println("# Some : comments : to skip");
            pw.println("###########################");
            pw.println("mykey1: myvalue1");
            pw.println("mykey2       : myvalue2");
            pw.println("mykey3:myvalue3");
            pw.println(" some nonsense without colon and whitespace separator");
            pw.println(" :  ");
            pw.println("   ");
            pw.println(" ");
            pw.println("mykey4: myvalue4# some comments");
            pw.println("   mykey5    :    myvalue5    ");
            pw.println("mykey6: my: value6");
            pw.println("mykey7: ");
            pw.println(": myvalue8");
            pw.println("mykey9: myvalue9");
            pw.println("mykey9: myvalue10");
        }
        Map conf = ConfigurationFileMigrationUtils.loadLegacyYAMLResource((File)confFile);
        Assertions.assertThat(conf.keySet()).hasSize(6);
        Assertions.assertThat((String)conf.getOrDefault("mykey1", null)).isEqualTo("myvalue1");
        Assertions.assertThat((String)conf.getOrDefault("mykey1", null)).isEqualTo("myvalue1");
        Assertions.assertThat((String)conf.getOrDefault("mykey2", null)).isEqualTo("myvalue2");
        Assertions.assertThat((String)conf.getOrDefault("mykey3", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getOrDefault("mykey4", null)).isEqualTo("myvalue4");
        Assertions.assertThat((String)conf.getOrDefault("mykey5", null)).isEqualTo("myvalue5");
        Assertions.assertThat((String)conf.getOrDefault("mykey6", null)).isEqualTo("my: value6");
        Assertions.assertThat((String)conf.getOrDefault("mykey7", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getOrDefault("mykey8", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getOrDefault("mykey9", null)).isEqualTo("myvalue10");
    }

    @Test
    void testInvalidLegacyYamlFile() throws IOException {
        File confFile = new File(this.tmpDir.getPath(), "flink-conf.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.append("invalid");
        }
        Assertions.assertThat((Map)ConfigurationFileMigrationUtils.loadLegacyYAMLResource((File)confFile)).isNotNull();
    }
}

