/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.tuple.base;

import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TuplePairComparatorTestBase<T extends Tuple, R extends Tuple> {
    protected abstract TypePairComparator<T, R> createComparator(boolean var1);

    protected abstract Tuple2<T[], R[]> getSortedTestData();

    @Test
    void testEqualityWithReference() {
        TypePairComparator<T, R> comparator = this.getComparator(true);
        Tuple2<T[], R[]> data = this.getSortedData();
        for (int x = 0; x < ((Tuple[])data.f0).length; ++x) {
            comparator.setReference((Object)((Tuple[])data.f0)[x]);
            Assertions.assertThat((boolean)comparator.equalToReference((Object)((Tuple[])data.f1)[x])).isTrue();
        }
    }

    @Test
    void testInequalityWithReference() {
        this.testGreatSmallAscDescWithReference(true);
        this.testGreatSmallAscDescWithReference(false);
    }

    protected void testGreatSmallAscDescWithReference(boolean ascending) {
        Tuple2<T[], R[]> data = this.getSortedData();
        TypePairComparator<T, R> comparator = this.getComparator(ascending);
        for (int x = 0; x < ((Tuple[])data.f0).length - 1; ++x) {
            for (int y = x + 1; y < ((Tuple[])data.f1).length; ++y) {
                comparator.setReference((Object)((Tuple[])data.f0)[x]);
                if (ascending) {
                    Assertions.assertThat((int)comparator.compareToReference((Object)((Tuple[])data.f1)[y])).isPositive();
                    continue;
                }
                Assertions.assertThat((int)comparator.compareToReference((Object)((Tuple[])data.f1)[y])).isNegative();
            }
        }
    }

    protected TypePairComparator<T, R> getComparator(boolean ascending) {
        TypePairComparator<T, R> comparator = this.createComparator(ascending);
        if (comparator == null) {
            throw new RuntimeException("Test case corrupt. Returns null as comparator.");
        }
        return comparator;
    }

    protected Tuple2<T[], R[]> getSortedData() {
        Tuple2<T[], R[]> data = this.getSortedTestData();
        if (data == null || data.f0 == null || data.f1 == null) {
            throw new RuntimeException("Test case corrupt. Returns null as test data.");
        }
        if (((Tuple[])data.f0).length < 2 || ((Tuple[])data.f1).length < 2) {
            throw new RuntimeException("Test case does not provide enough sorted test data.");
        }
        return data;
    }
}

