/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.assertj.core.api.Condition;

class ValueSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<NameValue, NameValue> {
    ValueSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("value-serializer", flinkVersion, ValueSerializerSetup.class, ValueSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class NameValue
    implements Value {
        public static final long serialVersionUID = 2277251654485371327L;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeUTF(this.name);
        }

        public void read(DataInputView in) throws IOException {
            this.name = in.readUTF();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NameValue)) {
                return false;
            }
            NameValue other = (NameValue)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    public static final class ValueSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NameValue> {
        @Override
        public TypeSerializer<NameValue> createUpgradedSerializer() {
            return new ValueSerializer(NameValue.class);
        }

        @Override
        public Condition<NameValue> testDataCondition() {
            NameValue value = new NameValue();
            value.setName("klion26");
            return new Condition(value::equals, "value is klion26", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<NameValue>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class ValueSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NameValue> {
        @Override
        public TypeSerializer<NameValue> createPriorSerializer() {
            return new ValueSerializer(NameValue.class);
        }

        @Override
        public NameValue createTestData() {
            NameValue value = new NameValue();
            value.setName("klion26");
            return value;
        }
    }
}

