/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.assertj.core.api.Condition;

class TupleSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Tuple3<String, String, Integer>, Tuple3<String, String, Integer>> {
    TupleSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("tuple-serializer", flinkVersion, TupleSerializerSetup.class, TupleSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class TupleSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Tuple3<String, String, Integer>> {
        @Override
        public TypeSerializer<Tuple3<String, String, Integer>> createUpgradedSerializer() {
            return new TupleSerializer(Tuple3.class, new TypeSerializer[]{StringSerializer.INSTANCE, StringSerializer.INSTANCE, IntSerializer.INSTANCE});
        }

        @Override
        public Condition<Tuple3<String, String, Integer>> testDataCondition() {
            Tuple3 value = new Tuple3((Object)"hello Gordon", (Object)"ciao", (Object)14);
            return new Condition(arg_0 -> ((Tuple3)value).equals(arg_0), "value is (hello Gordon, ciao, 14)", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Tuple3<String, String, Integer>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class TupleSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Tuple3<String, String, Integer>> {
        @Override
        public TypeSerializer<Tuple3<String, String, Integer>> createPriorSerializer() {
            return new TupleSerializer(Tuple3.class, new TypeSerializer[]{StringSerializer.INSTANCE, StringSerializer.INSTANCE, IntSerializer.INSTANCE});
        }

        @Override
        public Tuple3<String, String, Integer> createTestData() {
            return new Tuple3((Object)"hello Gordon", (Object)"ciao", (Object)14);
        }
    }
}

