/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.util.StringUtils;
import org.junit.jupiter.api.Test;

class TupleSerializerTest {
    TupleSerializerTest() {
    }

    @Test
    void testTuple0() {
        Tuple0[] testTuples = new Tuple0[]{Tuple0.INSTANCE, Tuple0.INSTANCE, Tuple0.INSTANCE};
        this.runTests(1, (Tuple[])testTuples);
    }

    @Test
    void testTuple1Int() {
        Tuple1[] testTuples = new Tuple1[]{new Tuple1((Object)42), new Tuple1((Object)1), new Tuple1((Object)0), new Tuple1((Object)-1), new Tuple1((Object)Integer.MAX_VALUE), new Tuple1((Object)Integer.MIN_VALUE)};
        this.runTests(4, (Tuple[])testTuples);
    }

    @Test
    void testTuple1String() {
        Random rnd = new Random(68761564135413L);
        Tuple1[] testTuples = new Tuple1[]{new Tuple1((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100)), new Tuple1((Object)"abc"), new Tuple1((Object)""), new Tuple1((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170)), new Tuple1((Object)StringUtils.getRandomString((Random)rnd, (int)15, (int)50)), new Tuple1((Object)"")};
        this.runTests(-1, (Tuple[])testTuples);
    }

    @Test
    void testTuple1StringArray() {
        Random rnd = new Random(289347567856686223L);
        String[] arr1 = new String[]{"abc", "", StringUtils.getRandomString((Random)rnd, (int)10, (int)100), StringUtils.getRandomString((Random)rnd, (int)15, (int)50), StringUtils.getRandomString((Random)rnd, (int)30, (int)170), StringUtils.getRandomString((Random)rnd, (int)14, (int)15), ""};
        String[] arr2 = new String[]{"foo", "", StringUtils.getRandomString((Random)rnd, (int)10, (int)100), StringUtils.getRandomString((Random)rnd, (int)1000, (int)5000), StringUtils.getRandomString((Random)rnd, (int)30000, (int)35000), StringUtils.getRandomString((Random)rnd, (int)102400, (int)107520), "bar"};
        Tuple1[] testTuples = new Tuple1[]{new Tuple1((Object)arr1), new Tuple1((Object)arr2)};
        this.runTests(-1, (Tuple[])testTuples);
    }

    @Test
    void testTuple2StringDouble() {
        Random rnd = new Random(807346528946L);
        Tuple2[] testTuples = new Tuple2[]{new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (Object)rnd.nextDouble()), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (Object)rnd.nextDouble()), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (Object)rnd.nextDouble()), new Tuple2((Object)"", (Object)rnd.nextDouble()), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (Object)rnd.nextDouble()), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (Object)rnd.nextDouble())};
        this.runTests(-1, (Tuple[])testTuples);
    }

    @Test
    void testTuple2StringStringArray() {
        Random rnd = new Random(289347567856686223L);
        String[] arr1 = new String[]{"abc", "", StringUtils.getRandomString((Random)rnd, (int)10, (int)100), StringUtils.getRandomString((Random)rnd, (int)15, (int)50), StringUtils.getRandomString((Random)rnd, (int)30, (int)170), StringUtils.getRandomString((Random)rnd, (int)14, (int)15), ""};
        String[] arr2 = new String[]{"foo", "", StringUtils.getRandomString((Random)rnd, (int)10, (int)100), StringUtils.getRandomString((Random)rnd, (int)1000, (int)5000), StringUtils.getRandomString((Random)rnd, (int)30000, (int)35000), StringUtils.getRandomString((Random)rnd, (int)102400, (int)107520), "bar"};
        Tuple2[] testTuples = new Tuple2[]{new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170), (Object)arr1), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170), (Object)arr2), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170), (Object)arr1), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170), (Object)arr2), new Tuple2((Object)StringUtils.getRandomString((Random)rnd, (int)30, (int)170), (Object)arr2)};
        this.runTests(-1, (Tuple[])testTuples);
    }

    @Test
    void testTuple5CustomObjects() {
        Random rnd = new Random(807346528946L);
        AbstractGenericTypeSerializerTest.SimpleTypes a = new AbstractGenericTypeSerializerTest.SimpleTypes();
        AbstractGenericTypeSerializerTest.SimpleTypes b = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes c = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes d = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes e = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes f = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes g = new AbstractGenericTypeSerializerTest.SimpleTypes(rnd.nextInt(), rnd.nextLong(), (byte)rnd.nextInt(), StringUtils.getRandomString((Random)rnd, (int)10, (int)100), (short)rnd.nextInt(), rnd.nextDouble());
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o1 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(5626435);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o2 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(76923);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o3 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(-1100);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o4 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(0);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o5 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(44);
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 co1 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(rnd);
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 co2 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2();
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 co3 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(rnd);
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 co4 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(rnd);
        AbstractGenericTypeSerializerTest.Book b1 = new AbstractGenericTypeSerializerTest.Book(976243875L, "The Serialization Odysse", 42L);
        AbstractGenericTypeSerializerTest.Book b2 = new AbstractGenericTypeSerializerTest.Book(0L, "Debugging byte streams", 1337L);
        AbstractGenericTypeSerializerTest.Book b3 = new AbstractGenericTypeSerializerTest.Book(-1L, "Low level interfaces", 12648430L);
        AbstractGenericTypeSerializerTest.Book b4 = new AbstractGenericTypeSerializerTest.Book(Long.MAX_VALUE, "The joy of bits and bytes", -559038737L);
        AbstractGenericTypeSerializerTest.Book b5 = new AbstractGenericTypeSerializerTest.Book(Long.MIN_VALUE, "Winnign a prize for creative test strings", 12246784L);
        AbstractGenericTypeSerializerTest.Book b6 = new AbstractGenericTypeSerializerTest.Book(-2L, "Distributed Systems", -6066930334832433271L);
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        AbstractGenericTypeSerializerTest.BookAuthor ba1 = new AbstractGenericTypeSerializerTest.BookAuthor(976243875L, list, "Arno Nym");
        ArrayList<String> list2 = new ArrayList<String>();
        AbstractGenericTypeSerializerTest.BookAuthor ba2 = new AbstractGenericTypeSerializerTest.BookAuthor(987654321L, list2, "The Saurus");
        Tuple5[] testTuples = new Tuple5[]{new Tuple5((Object)a, (Object)b1, (Object)o1, (Object)ba1, (Object)co1), new Tuple5((Object)b, (Object)b2, (Object)o2, (Object)ba2, (Object)co2), new Tuple5((Object)c, (Object)b3, (Object)o3, (Object)ba1, (Object)co3), new Tuple5((Object)d, (Object)b2, (Object)o4, (Object)ba1, (Object)co4), new Tuple5((Object)e, (Object)b4, (Object)o5, (Object)ba2, (Object)co4), new Tuple5((Object)f, (Object)b5, (Object)o1, (Object)ba2, (Object)co4), new Tuple5((Object)g, (Object)b6, (Object)o4, (Object)ba1, (Object)co2)};
        this.runTests(-1, (Tuple[])testTuples);
    }

    private <T extends Tuple> void runTests(int length, T ... instances) {
        TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)TypeExtractor.getForObject(instances[0]);
        TupleSerializer serializer = tupleTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        Class tupleClass = tupleTypeInfo.getTypeClass();
        if (tupleClass == Tuple0.class) {
            length = 1;
        }
        SerializerTestInstance test = new SerializerTestInstance<T>((TypeSerializer)serializer, tupleClass, length, (Tuple[])instances){};
        test.testAll();
    }
}

