/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshot;
import org.apache.flink.testutils.migration.SchemaCompatibilityTestingSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoSerializerSnapshotTest {
    private static final Map<String, Field> FIELDS = new HashMap<String, Field>(3);
    private static final TestPojoField ID_FIELD;
    private static final TestPojoField NAME_FIELD;
    private static final TestPojoField HEIGHT_FIELD;

    PojoSerializerSnapshotTest() {
    }

    @Test
    void testRestoreSerializerWithSameFields() {
        PojoSerializerSnapshot<TestPojo> testSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, HEIGHT_FIELD));
        TypeSerializer restoredSerializer = testSnapshot.restoreSerializer();
        Assertions.assertThat(restoredSerializer.getClass()).isSameAs(PojoSerializer.class);
        PojoSerializer restoredPojoSerializer = (PojoSerializer)restoredSerializer;
        Object[] restoredFields = restoredPojoSerializer.getFields();
        Assertions.assertThat((Object[])restoredFields).containsExactly((Object[])new Field[]{PojoSerializerSnapshotTest.ID_FIELD.field, PojoSerializerSnapshotTest.NAME_FIELD.field, PojoSerializerSnapshotTest.HEIGHT_FIELD.field});
        Object[] restoredFieldSerializers = restoredPojoSerializer.getFieldSerializers();
        Assertions.assertThat((Object[])restoredFieldSerializers).containsExactly((Object[])new TypeSerializer[]{IntSerializer.INSTANCE, StringSerializer.INSTANCE, DoubleSerializer.INSTANCE});
    }

    @Test
    void testRestoreSerializerWithRemovedFields() {
        PojoSerializerSnapshot<TestPojo> testSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(PojoSerializerSnapshotTest.mockRemovedField(ID_FIELD), NAME_FIELD, PojoSerializerSnapshotTest.mockRemovedField(HEIGHT_FIELD)));
        TypeSerializer restoredSerializer = testSnapshot.restoreSerializer();
        Assertions.assertThat((Object)restoredSerializer).isInstanceOf(PojoSerializer.class);
        PojoSerializer restoredPojoSerializer = (PojoSerializer)restoredSerializer;
        Object[] restoredFields = restoredPojoSerializer.getFields();
        Assertions.assertThat((Object[])restoredFields).containsExactly((Object[])new Field[]{null, PojoSerializerSnapshotTest.NAME_FIELD.field, null});
        Object[] restoredFieldSerializers = restoredPojoSerializer.getFieldSerializers();
        Assertions.assertThat((Object[])restoredFieldSerializers).containsExactly((Object[])new TypeSerializer[]{IntSerializer.INSTANCE, StringSerializer.INSTANCE, DoubleSerializer.INSTANCE});
    }

    @Test
    void testRestoreSerializerWithNewFields() {
        PojoSerializerSnapshot<TestPojo> testSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Collections.singletonList(HEIGHT_FIELD));
        TypeSerializer restoredSerializer = testSnapshot.restoreSerializer();
        Assertions.assertThat((Object)restoredSerializer).isInstanceOf(PojoSerializer.class);
        PojoSerializer restoredPojoSerializer = (PojoSerializer)restoredSerializer;
        Object[] restoredFields = restoredPojoSerializer.getFields();
        Assertions.assertThat((Object[])restoredFields).containsExactly((Object[])new Field[]{PojoSerializerSnapshotTest.HEIGHT_FIELD.field});
        Object[] restoredFieldSerializers = restoredPojoSerializer.getFieldSerializers();
        Assertions.assertThat((Object[])restoredFieldSerializers).containsExactly((Object[])new TypeSerializer[]{DoubleSerializer.INSTANCE});
    }

    @Test
    void testResolveSchemaCompatibilityWithSameFields() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, HEIGHT_FIELD));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, HEIGHT_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleAsIs()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithRemovedFields() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(PojoSerializerSnapshotTest.mockRemovedField(ID_FIELD), NAME_FIELD, PojoSerializerSnapshotTest.mockRemovedField(HEIGHT_FIELD)));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Collections.singletonList(NAME_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleAfterMigration()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithNewFields() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Collections.singletonList(HEIGHT_FIELD));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, HEIGHT_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleAfterMigration()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithNewAndRemovedFields() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Collections.singletonList(PojoSerializerSnapshotTest.mockRemovedField(ID_FIELD)));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(NAME_FIELD, HEIGHT_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleAfterMigration()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithIncompatibleFieldSerializers() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(NAME_FIELD, new SchemaCompatibilityTestingSerializer().snapshotConfiguration()), HEIGHT_FIELD));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(NAME_FIELD, SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsIncompatibleWithTheLastSerializer()), HEIGHT_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isIncompatible()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithCompatibleAfterMigrationFieldSerializers() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(HEIGHT_FIELD, new SchemaCompatibilityTestingSerializer().snapshotConfiguration())));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(ID_FIELD, NAME_FIELD, PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(HEIGHT_FIELD, SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterMigration())));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleAfterMigration()).isTrue();
    }

    @Test
    void testResolveSchemaCompatibilityWithCompatibleWithReconfigurationFieldSerializers() {
        PojoSerializerSnapshot<TestPojo> oldSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(ID_FIELD, new SchemaCompatibilityTestingSerializer().snapshotConfiguration()), NAME_FIELD, HEIGHT_FIELD));
        PojoSerializerSnapshot<TestPojo> newSnapshot = PojoSerializerSnapshotTest.buildTestSnapshot(Arrays.asList(PojoSerializerSnapshotTest.mockFieldSerializerSnapshot(ID_FIELD, SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration()), NAME_FIELD, HEIGHT_FIELD));
        TypeSerializerSchemaCompatibility resultCompatibility = newSnapshot.resolveSchemaCompatibility(oldSnapshot);
        Assertions.assertThat((boolean)resultCompatibility.isCompatibleWithReconfiguredSerializer()).isTrue();
        TypeSerializer reconfiguredSerializer = resultCompatibility.getReconfiguredSerializer();
        Assertions.assertThat(reconfiguredSerializer.getClass()).isSameAs(PojoSerializer.class);
        PojoSerializer reconfiguredPojoSerializer = (PojoSerializer)reconfiguredSerializer;
        Object[] reconfiguredFieldSerializers = reconfiguredPojoSerializer.getFieldSerializers();
        Assertions.assertThat((Object[])reconfiguredFieldSerializers).containsExactly((Object[])new TypeSerializer[]{new SchemaCompatibilityTestingSerializer(), StringSerializer.INSTANCE, DoubleSerializer.INSTANCE});
    }

    private static PojoSerializerSnapshot<TestPojo> buildTestSnapshot(List<TestPojoField> fieldsToContainInSnapshot) {
        int numFields = fieldsToContainInSnapshot.size();
        ArrayList fields = new ArrayList(numFields);
        ArrayList fieldSerializerSnapshots = new ArrayList(numFields);
        fieldsToContainInSnapshot.forEach(testPojoField -> {
            fields.add(testPojoField.field);
            fieldSerializerSnapshots.add(testPojoField.serializerSnapshot);
        });
        return new PojoSerializerSnapshot(TestPojo.class, fields.toArray(new Field[numFields]), fieldSerializerSnapshots.toArray(new TypeSerializerSnapshot[numFields]), new LinkedHashMap(), new LinkedHashMap(), (SerializerConfig)new SerializerConfigImpl());
    }

    private static TestPojoField mockRemovedField(TestPojoField original) {
        TestPojoField copy = original.shallowCopy();
        copy.field = null;
        return copy;
    }

    private static TestPojoField mockFieldSerializerSnapshot(TestPojoField original, TypeSerializerSnapshot<?> mockSnapshot) {
        TestPojoField copy = original.shallowCopy();
        copy.serializerSnapshot = mockSnapshot;
        return copy;
    }

    static {
        try {
            FIELDS.put("id", TestPojo.class.getDeclaredField("id"));
            FIELDS.put("name", TestPojo.class.getDeclaredField("name"));
            FIELDS.put("height", TestPojo.class.getDeclaredField("height"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            ID_FIELD = new TestPojoField("id", (TypeSerializer<?>)IntSerializer.INSTANCE);
            NAME_FIELD = new TestPojoField("name", (TypeSerializer<?>)StringSerializer.INSTANCE);
            HEIGHT_FIELD = new TestPojoField("height", (TypeSerializer<?>)DoubleSerializer.INSTANCE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TestPojoField {
        String name;
        Field field;
        TypeSerializer<?> serializer;
        TypeSerializerSnapshot<?> serializerSnapshot;

        TestPojoField(String name, TypeSerializer<?> serializer) throws Exception {
            this.name = name;
            this.field = TestPojo.class.getDeclaredField(name);
            this.serializer = serializer;
            this.serializerSnapshot = serializer.snapshotConfiguration();
        }

        TestPojoField(String name, Field field, TypeSerializerSnapshot<?> serializerSnapshot) {
            this.name = name;
            this.field = field;
            this.serializerSnapshot = serializerSnapshot;
        }

        TestPojoField shallowCopy() {
            return new TestPojoField(this.name, this.field, this.serializerSnapshot);
        }
    }

    public static class TestPojo {
        public int id;
        public String name;
        public double height;

        public TestPojo() {
        }

        public TestPojo(int id, String name, double height) {
            this.id = id;
            this.name = name;
            this.height = height;
        }
    }
}

