/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DataInputViewStreamTest {
    DataInputViewStreamTest() {
    }

    @Test
    void testSkip() throws IOException {
        TestInputStream inputStream = new TestInputStream();
        try (TestDataInputView dataInputView = new TestDataInputView(inputStream);
             DataInputViewStream dataInputViewStream = new DataInputViewStream((DataInputView)dataInputView);){
            Assertions.assertThat((long)dataInputViewStream.skip(1L)).isOne();
            Assertions.assertThat((long)inputStream.skipped).isOne();
            long bigNumberToSkip = 4294968318L;
            Assertions.assertThat((long)dataInputViewStream.skip(4294968318L)).isEqualTo(4294968318L);
            Assertions.assertThat((long)inputStream.skipped).isEqualTo(4294968319L);
        }
    }

    private static class TestInputStream
    extends InputStream {
        long skipped = 0L;

        private TestInputStream() {
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public long skip(long n) {
            this.skipped += n;
            return n;
        }
    }

    private static class TestDataInputView
    extends DataInputStream
    implements DataInputView {
        TestDataInputView(InputStream in) {
            super(in);
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            throw new UnsupportedOperationException("Not properly implemented.");
        }
    }
}

