/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.NullableListTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class PojoTypeExtractionTest {
    @Test
    void testDuplicateFieldException() {
        TypeInformation ti = TypeExtractor.createTypeInfo(HasDuplicateField.class);
        Assertions.assertThat((Object)ti).isInstanceOf(GenericTypeInfo.class);
    }

    @Test
    void testPojoWithGenericFields() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenericFields.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
    }

    @Test
    void testIncorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(IncorrectPojo.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(GenericTypeInfo.class);
        typeForClass = TypeExtractor.createTypeInfo(WrongCtorPojo.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(GenericTypeInfo.class);
    }

    @Test
    void testCorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(BeanStylePojo.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
        typeForClass = TypeExtractor.createTypeInfo(TypedPojoGetterSetterCheck.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
    }

    @Test
    void testPojoWC() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(WC.class);
        this.checkWCPojoAsserts(typeForClass);
        WC t = new WC();
        t.complex = new ComplexNestedClass();
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)t);
        this.checkWCPojoAsserts(typeForObject);
    }

    private void checkWCPojoAsserts(TypeInformation<?> typeInfo) {
        int pos;
        Assertions.assertThat((boolean)typeInfo.isBasicType()).isFalse();
        Assertions.assertThat((boolean)typeInfo.isTupleType()).isFalse();
        Assertions.assertThat((int)typeInfo.getTotalFields()).isEqualTo(10);
        Assertions.assertThat(typeInfo).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pojoType = (PojoTypeInfo)typeInfo;
        ArrayList ffd = new ArrayList();
        Object[] fields = new String[]{"count", "complex.date", "complex.collection", "complex.nothing", "complex.someFloat", "complex.someNumberWith\u00dcnic\u00f6deN\u00e4me", "complex.valueType", "complex.word.f0", "complex.word.f1", "complex.word.f2"};
        int[] positions = new int[]{9, 1, 0, 2, 3, 4, 5, 6, 7, 8};
        Assertions.assertThat((Object[])fields).hasSameSizeAs((Object)positions);
        for (int i = 0; i < fields.length; ++i) {
            pojoType.getFlatFields((String)fields[i], 0, ffd);
            ((ListAssert)Assertions.assertThat(ffd).as("Too many keys returned", new Object[0])).hasSize(1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition()).as("position of field " + (String)fields[i] + " wrong", new Object[0])).isEqualTo(positions[i]);
            ffd.clear();
        }
        pojoType.getFlatFields("complex.word.*", 0, ffd);
        Assertions.assertThat(ffd).hasSize(3);
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assertions.assertThat((int)pos).isGreaterThanOrEqualTo(6).isLessThanOrEqualTo(8);
            if (pos == 6) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Long.class);
            }
            if (pos == 7) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Long.class);
            }
            if (pos != 8) continue;
            Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(String.class);
        }
        ffd.clear();
        pojoType.getFlatFields("complex.word._", 0, ffd);
        Assertions.assertThat(ffd).hasSize(3);
        ffd.clear();
        pojoType.getFlatFields("complex.*", 0, ffd);
        Assertions.assertThat(ffd).hasSize(9);
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assertions.assertThat((int)ffdE.getPosition()).isGreaterThanOrEqualTo(0).isLessThanOrEqualTo(8);
            if (pos == 0) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(List.class);
            }
            if (pos == 1) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Date.class);
            }
            if (pos == 2) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Object.class);
            }
            if (pos == 3) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Float.class);
            }
            if (pos == 4) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Integer.class);
            }
            if (pos == 5) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(MyValue.class);
            }
            if (pos == 6) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Long.class);
            }
            if (pos == 7) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Long.class);
            }
            if (pos == 8) {
                Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(String.class);
            }
            if (pos != 9) continue;
            Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Integer.class);
        }
        ffd.clear();
        pojoType.getFlatFields("*", 0, ffd);
        Assertions.assertThat(ffd).hasSize(10);
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            Assertions.assertThat((ffdE.getPosition() <= 9 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((0 <= ffdE.getPosition() ? 1 : 0) != 0).isTrue();
            if (ffdE.getPosition() != 9) continue;
            Assertions.assertThat((Class)ffdE.getType().getTypeClass()).isEqualTo(Integer.class);
        }
        ffd.clear();
        TypeInformation typeComplexNested = pojoType.getTypeAt(0);
        Assertions.assertThat((Object)typeComplexNested).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((int)typeComplexNested.getArity()).isEqualTo(7);
        Assertions.assertThat((int)typeComplexNested.getTotalFields()).isEqualTo(9);
        PojoTypeInfo pojoTypeComplexNested = (PojoTypeInfo)typeComplexNested;
        boolean dateSeen = false;
        boolean intSeen = false;
        boolean floatSeen = false;
        boolean tupleSeen = false;
        boolean objectSeen = false;
        boolean writableSeen = false;
        boolean collectionSeen = false;
        for (int i = 0; i < pojoTypeComplexNested.getArity(); ++i) {
            PojoField field = pojoTypeComplexNested.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("date")) {
                if (dateSeen) {
                    Assertions.fail((String)"already seen");
                }
                dateSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.DATE_TYPE_INFO);
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(Date.class);
                continue;
            }
            if (name.equals("someNumberWith\u00dcnic\u00f6deN\u00e4me")) {
                if (intSeen) {
                    Assertions.fail((String)"already seen");
                }
                intSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(Integer.class);
                continue;
            }
            if (name.equals("someFloat")) {
                if (floatSeen) {
                    Assertions.fail((String)"already seen");
                }
                floatSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(Float.class);
                continue;
            }
            if (name.equals("word")) {
                if (tupleSeen) {
                    Assertions.fail((String)"already seen");
                }
                tupleSeen = true;
                Assertions.assertThat((boolean)(field.getTypeInformation() instanceof TupleTypeInfo)).isTrue();
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(Tuple3.class);
                TupleTypeInfo tupleTypeFromComplexNested = (TupleTypeInfo)field.getTypeInformation();
                Assertions.assertThat((Object)tupleTypeFromComplexNested.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
                Assertions.assertThat((Object)tupleTypeFromComplexNested.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
                Assertions.assertThat((Object)tupleTypeFromComplexNested.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("nothing")) {
                if (objectSeen) {
                    Assertions.fail((String)"already seen");
                }
                objectSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new GenericTypeInfo(Object.class));
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(Object.class);
                continue;
            }
            if (name.equals("valueType")) {
                if (writableSeen) {
                    Assertions.fail((String)"already seen");
                }
                writableSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new ValueTypeInfo(MyValue.class));
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(MyValue.class);
                continue;
            }
            if (name.equals("collection")) {
                if (collectionSeen) {
                    Assertions.fail((String)"already seen");
                }
                collectionSeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new NullableListTypeInfo(String.class));
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dateSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)floatSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tupleSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)objectSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)writableSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)collectionSeen).as("Field was not present", new Object[0])).isTrue();
        TypeInformation typeAtOne = pojoType.getTypeAt(1);
        Assertions.assertThat((Object)typeAtOne).isInstanceOf(BasicTypeInfo.class);
        Assertions.assertThat((Class)typeInfo.getTypeClass()).isEqualTo(WC.class);
        Assertions.assertThat((int)typeInfo.getArity()).isEqualTo(2);
    }

    @Test
    void testPojoAllPublic() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(AllPublic.class);
        this.checkAllPublicAsserts(typeForClass);
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)new AllPublic());
        this.checkAllPublicAsserts(typeForObject);
    }

    private void checkAllPublicAsserts(TypeInformation<?> typeInformation) {
        Assertions.assertThat(typeInformation).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((int)typeInformation.getArity()).isEqualTo(10);
        Assertions.assertThat((int)typeInformation.getTotalFields()).isEqualTo(12);
        boolean arrayListSeen = false;
        boolean multisetSeen = false;
        boolean strArraySeen = false;
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("somethingFancy")) {
                if (arrayListSeen) {
                    Assertions.fail((String)"already seen");
                }
                arrayListSeen = true;
                Assertions.assertThat((boolean)(field.getTypeInformation() instanceof GenericTypeInfo)).isTrue();
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(ArrayList.class);
                continue;
            }
            if (name.equals("fancyIds")) {
                if (multisetSeen) {
                    Assertions.fail((String)"already seen");
                }
                multisetSeen = true;
                Assertions.assertThat((boolean)(field.getTypeInformation() instanceof GenericTypeInfo)).isTrue();
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(FancyCollectionSubtype.class);
                continue;
            }
            if (name.equals("fancyArray")) {
                if (strArraySeen) {
                    Assertions.fail((String)"already seen");
                }
                strArraySeen = true;
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO);
                Assertions.assertThat((Class)field.getTypeInformation().getTypeClass()).isEqualTo(String[].class);
                continue;
            }
            if (Arrays.asList("date", "someNumberWith\u00dcnic\u00f6deN\u00e4me", "someFloat", "word", "nothing", "valueType", "collection").contains(name)) continue;
            Assertions.fail((String)("Unexpected field " + field));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)arrayListSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)multisetSeen).as("Field was not present", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)strArraySeen).as("Field was not present", new Object[0])).isTrue();
    }

    @Test
    void testPojoExtendingTuple() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(FromTuple.class);
        this.checkFromTuplePojo(typeForClass);
        FromTuple ft = new FromTuple();
        ft.f0 = "";
        ft.f1 = "";
        ft.f2 = 0L;
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)((Object)ft));
        this.checkFromTuplePojo(typeForObject);
    }

    private void checkFromTuplePojo(TypeInformation<?> typeInformation) {
        Assertions.assertThat(typeInformation).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((int)typeInformation.getTotalFields()).isEqualTo(4);
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("special")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            if (name.equals("f0") || name.equals("f1")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("f2")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)"unexpected field");
        }
    }

    @Test
    void testPojoWithGenerics() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ParentSettingGenerics.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            if (name.equals("field2")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
                continue;
            }
            if (name.equals("field3")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("key")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    void testPojoWithGenericsSomeFieldsGeneric() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenerics.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new GenericTypeInfo(Object.class));
                continue;
            }
            if (name.equals("field2")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)new GenericTypeInfo(Object.class));
                continue;
            }
            if (name.equals("key")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    void testPojoWithComplexHierarchy() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ComplexHierarchyTop.class);
        Assertions.assertThat((Object)typeForClass).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assertions.assertThat((boolean)(field.getTypeInformation() instanceof PojoTypeInfo)).isTrue();
                continue;
            }
            if (name.equals("field2")) {
                Assertions.assertThat((boolean)(field.getTypeInformation() instanceof TupleTypeInfo)).isTrue();
                Assertions.assertThat((Object)((TupleTypeInfo)field.getTypeInformation()).getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("key")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    void testGenericPojoTypeInference1() {
        MyMapper function = new MyMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithGenerics<Long, String>>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField field = pti.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("field2")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
                continue;
            }
            if (name.equals("key")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    void testGenericPojoTypeInference2() {
        MyMapper2 function = new MyMapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Character, Boolean>>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField field = pti.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("extraField")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.CHAR_TYPE_INFO);
                continue;
            }
            if (name.equals("f0")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
                continue;
            }
            if (name.equals("f1")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
                continue;
            }
            if (name.equals("f2")) {
                Assertions.assertThat((Object)field.getTypeInformation()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
                continue;
            }
            Assertions.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    void testGenericPojoTypeInference3() {
        MyMapper3 function = new MyMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoTuple<Character, Boolean, Boolean>>(){}));
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.CHAR_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testGenericPojoTypeInference4() {
        MyMapper4 function = new MyMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields1<Byte>>(){}));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BYTE_TYPE_INFO);
    }

    @Test
    void testGenericPojoTypeInference5() {
        MyMapper5 function = new MyMapper5();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields2<Byte>>(){}));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.BYTE_TYPE_INFO);
    }

    @Test
    void testGenericPojoTypeInference6() {
        MyMapper6 function = new MyMapper6();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields3<Integer>>(){}));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testGenericPojoTypeInference7() {
        MyMapper7 function = new MyMapper7();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields4<Integer>>(){}));
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testRecursivePojo1() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo1.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat(((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation().getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testRecursivePojo2() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo2.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoField pf = ((PojoTypeInfo)ti).getPojoFieldAt(0);
        Assertions.assertThat((boolean)(pf.getTypeInformation() instanceof TupleTypeInfo)).isTrue();
        Assertions.assertThat(((TupleTypeInfo)pf.getTypeInformation()).getTypeAt(0).getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testRecursivePojo3() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo3.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoField pf = ((PojoTypeInfo)ti).getPojoFieldAt(0);
        Assertions.assertThat((boolean)(pf.getTypeInformation() instanceof PojoTypeInfo)).isTrue();
        Assertions.assertThat(((PojoTypeInfo)pf.getTypeInformation()).getPojoFieldAt(0).getTypeInformation().getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testDualUseOfPojo() {
        DuplicateMapper function = new DuplicateMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeExtractor.createTypeInfo(FooBarPojo.class));
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof PojoTypeInfo)).isTrue();
        Assertions.assertThat((boolean)(tti.getTypeAt(1) instanceof PojoTypeInfo)).isTrue();
    }

    @Test
    void testPojoWithRecursiveGenericField() {
        TypeInformation ti = TypeExtractor.createTypeInfo(PojoWithRecursiveGenericField.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat(((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation().getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testPojosWithMutualRecursion() {
        TypeInformation ti = TypeExtractor.createTypeInfo(MutualPojoB.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        TypeInformation pti = ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation();
        Assertions.assertThat((Object)pti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat(((PojoTypeInfo)pti).getPojoFieldAt(0).getTypeInformation().getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testRecursivePojoWithTypeVariable() {
        TypeInformation ti = TypeExtractor.createTypeInfo(MyType.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        TypeInformation pti = ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation();
        Assertions.assertThat((Object)pti).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat(((PojoTypeInfo)pti).getPojoFieldAt(0).getTypeInformation().getClass()).isEqualTo(GenericTypeInfo.class);
    }

    @Test
    void testLombokPojo() {
        TypeInformation ti = TypeExtractor.getForClass(TestLombok.class);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        Assertions.assertThat((Object)pti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)pti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)pti.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    public static class TestLombok {
        private int age = 10;
        private boolean isHealthy;
        private String name;

        public int getAge() {
            return this.age;
        }

        public boolean isHealthy() {
            return this.isHealthy;
        }

        public String getName() {
            return this.name;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public void setHealthy(boolean isHealthy) {
            this.isHealthy = isHealthy;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class MyType
    extends Container<Container<Object>> {
    }

    public static class Container<T> {
        public T field;
    }

    public static class MutualPojoB {
        public MutualPojoA field;
    }

    public static class MutualPojoA {
        public MutualPojoB field;
    }

    public static class PojoWithRecursiveGenericField<K, V> {
        public PojoWithRecursiveGenericField<K, V> parent;
    }

    public static class DuplicateMapper
    implements MapFunction<FooBarPojo, Tuple2<FooBarPojo, FooBarPojo>> {
        public Tuple2<FooBarPojo, FooBarPojo> map(FooBarPojo value) throws Exception {
            return null;
        }
    }

    public static class FooBarPojo {
        public int foo;
        public int bar;
    }

    public static class NestedPojo {
        public RecursivePojo3 field;
    }

    public static class RecursivePojo3 {
        public NestedPojo field;
    }

    public static class RecursivePojo2 {
        public Tuple1<RecursivePojo2> field;
    }

    public static class RecursivePojo1 {
        public RecursivePojo1 field;
    }

    public static class PojoWithParameterizedFields4<Z> {
        public Tuple1<Z>[] field;
    }

    public static class MyMapper7<A>
    implements MapFunction<PojoWithParameterizedFields4<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields4<A> value) throws Exception {
            return null;
        }
    }

    public static class MyMapper6<A>
    implements MapFunction<PojoWithParameterizedFields3<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields3<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields3<Z> {
        public Z[] field;
    }

    public static class MyMapper5<A>
    implements MapFunction<PojoWithParameterizedFields2<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields2<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields2<Z> {
        public PojoWithGenerics<Z, Z> field;
    }

    public static class MyMapper4<A>
    implements MapFunction<PojoWithParameterizedFields1<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields1<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields1<Z> {
        public Tuple2<Z, Z> field;
    }

    public static class MyMapper3<D, E>
    implements MapFunction<PojoTuple<E, D, D>, Tuple2<E, D>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<E, D> map(PojoTuple<E, D, D> value) throws Exception {
            return null;
        }
    }

    public static class MyMapper2<D, E>
    implements MapFunction<Tuple2<E, D>, PojoTuple<E, D, D>> {
        private static final long serialVersionUID = 1L;

        public PojoTuple<E, D, D> map(Tuple2<E, D> value) throws Exception {
            return null;
        }
    }

    public static class PojoTuple<A, B, C>
    extends Tuple3<B, C, Long> {
        private static final long serialVersionUID = 1L;
        public A extraField;
    }

    public static class MyMapper<T>
    implements MapFunction<PojoWithGenerics<Long, T>, PojoWithGenerics<T, T>> {
        private static final long serialVersionUID = 1L;

        public PojoWithGenerics<T, T> map(PojoWithGenerics<Long, T> value) throws Exception {
            return null;
        }
    }

    public static class GenericPojoGetterSetterCheck<T> {
        T packageProtected;

        public T getPackageProtected() {
            return this.packageProtected;
        }
    }

    public static class TypedPojoGetterSetterCheck
    extends GenericPojoGetterSetterCheck<String> {
        public void setPackageProtected(String in) {
            this.packageProtected = in;
        }
    }

    public static class PojoWithGenericFields {
        private Collection<String> users;
        private boolean favorited;

        public boolean isFavorited() {
            return this.favorited;
        }

        public void setFavorited(boolean favorited) {
            this.favorited = favorited;
        }

        public Collection<String> getUsers() {
            return this.users;
        }

        public void setUsers(Collection<String> users) {
            this.users = users;
        }
    }

    public static class WrongCtorPojo {
        public int a;

        public WrongCtorPojo(int a) {
            this.a = a;
        }
    }

    public static class BeanStylePojo {
        public String abc;
        private int field;

        public int getField() {
            return this.field;
        }

        public void setField(int f) {
            this.field = f;
        }
    }

    public static class IncorrectPojo {
        private int isPrivate;

        public int getIsPrivate() {
            return this.isPrivate;
        }
    }

    public static class FromTuple
    extends Tuple3<String, String, Long> {
        private static final long serialVersionUID = 1L;
        public int special;
    }

    public static class ComplexHierarchy<T>
    extends PojoWithGenerics<FromTuple, T> {
    }

    public static class ComplexHierarchyTop
    extends ComplexHierarchy<Tuple1<String>> {
    }

    public static class PojoWithGenerics<T1, T2> {
        public int key;
        public T1 field1;
        public T2 field2;
    }

    public static class ParentSettingGenerics
    extends PojoWithGenerics<Integer, Long> {
        public String field3;
    }

    public static class FancyCollectionSubtype<T>
    extends HashSet<T> {
        private static final long serialVersionUID = -3494469602638179921L;
    }

    public static class AllPublic
    extends ComplexNestedClass {
        public ArrayList<String> somethingFancy;
        public FancyCollectionSubtype<Integer> fancyIds;
        public String[] fancyArray;
    }

    public static class ComplexNestedClass {
        public static int ignoreStaticField;
        public transient int ignoreTransientField;
        public Date date;
        public Integer someNumberWith\u00dcnic\u00f6deN\u00e4me;
        public float someFloat;
        public Tuple3<Long, Long, String> word;
        public Object nothing;
        public MyValue valueType;
        public List<String> collection;
    }

    public static class WC {
        public ComplexNestedClass complex;
        private int count;

        public int getCount() {
            return this.count;
        }

        public void setCount(int c) {
            this.count = c;
        }
    }

    public static class HasDuplicateField
    extends WC {
        private int count;
    }

    public static class MyValue
    implements Value {
        private static final long serialVersionUID = 8607223484689147046L;

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }
}

