/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.ComplexMap;
import org.apache.flink.api.java.NestedNonSerializableMapCreator;
import org.apache.flink.api.java.NestedSelfReferencing;
import org.apache.flink.api.java.NestedSerializableMapCreator;
import org.apache.flink.api.java.NonSerializableMapCreator;
import org.apache.flink.api.java.OuterMapCreator;
import org.apache.flink.api.java.RecursiveClass;
import org.apache.flink.api.java.SerializableMapCreator;
import org.apache.flink.api.java.WithWriteReplace;
import org.apache.flink.api.java.WrapperMapFunction;
import org.apache.flink.api.java.tuple.Tuple1;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class ClosureCleanerTest {
    ClosureCleanerTest() {
    }

    @Test
    void testNonSerializable() {
        Assertions.assertThatThrownBy(() -> {
            NonSerializableMapCreator creator = new NonSerializableMapCreator();
            MapFunction<Integer, Integer> map = creator.getMap();
            ClosureCleaner.ensureSerializable(map);
            int result = (Integer)map.map((Object)3);
            Assertions.assertThat((int)result).isEqualTo(4);
        }).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCleanedNonSerializable() throws Exception {
        NonSerializableMapCreator creator = new NonSerializableMapCreator();
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        int result = (Integer)map.map((Object)3);
        Assertions.assertThat((int)result).isEqualTo(4);
    }

    @Test
    void testSerializable() throws Exception {
        SerializableMapCreator creator = new SerializableMapCreator(1);
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        int result = (Integer)map.map((Object)3);
        Assertions.assertThat((int)result).isEqualTo(4);
    }

    @Test
    void testNestedSerializable() throws Exception {
        NestedSerializableMapCreator creator = new NestedSerializableMapCreator(1);
        MapFunction<Integer, Integer> map = creator.getMap();
        ClosureCleaner.clean(map, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.ensureSerializable(map);
        int result = (Integer)map.map((Object)3);
        Assertions.assertThat((int)result).isEqualTo(4);
    }

    @Test
    void testNestedNonSerializable() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            NestedNonSerializableMapCreator creator = new NestedNonSerializableMapCreator(1);
            MapFunction<Integer, Integer> map = creator.getMap();
            ClosureCleaner.clean(map, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
            ClosureCleaner.ensureSerializable(map);
            int result = (Integer)map.map((Object)3);
            Assertions.assertThat((int)result).isEqualTo(4);
        }).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testWrapperClass() throws Exception {
        NonSerializableMapCreator creator = new NonSerializableMapCreator();
        MapFunction<Integer, Integer> notCleanedMap = creator.getMap();
        WrapperMapFunction wrapped = new WrapperMapFunction(notCleanedMap);
        ClosureCleaner.clean((Object)wrapped, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.ensureSerializable((Object)wrapped);
        int result = wrapped.map(3);
        Assertions.assertThat((int)result).isEqualTo(4);
    }

    @Test
    void testComplexTopLevelClassClean() throws Exception {
        ComplexMap complexMap = new ComplexMap((MapFunction<Integer, Integer>)(MapFunction & Serializable)value -> value + 1);
        ClosureCleaner.clean((Object)complexMap, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        int result = (Integer)complexMap.map(3);
        Assertions.assertThat((int)result).isEqualTo(5);
    }

    @Test
    void testComplexInnerClassClean() throws Exception {
        InnerComplexMap complexMap = new InnerComplexMap((MapFunction<Integer, Integer>)(MapFunction & Serializable)value -> value + 1);
        ClosureCleaner.clean((Object)complexMap, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        int result = (Integer)complexMap.map(3);
        Assertions.assertThat((int)result).isEqualTo(4);
    }

    @Test
    void testSelfReferencingClean() {
        NestedSelfReferencing selfReferencing = new NestedSelfReferencing();
        ClosureCleaner.clean((Object)selfReferencing, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    @Test
    void testOuterStaticClassInnerStaticClassInnerAnonymousOrLocalClass() {
        MapFunction<Integer, Integer> nestedMap = new OuterMapCreator().getMap();
        WrapperMapFunction wrappedMap = new WrapperMapFunction(nestedMap);
        ClosureCleaner.clean((Object)wrappedMap, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.ensureSerializable((Object)wrappedMap);
    }

    @Test
    void testRealOuterStaticClassInnerStaticClassInnerAnonymousOrLocalClass() {
        MapFunction<Integer, Integer> nestedMap = new OuterMapCreator().getMap();
        WrapperMapFunction wrappedMap = new WrapperMapFunction(nestedMap);
        Tuple1 tuple = new Tuple1((Object)wrappedMap);
        ClosureCleaner.clean((Object)tuple, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.ensureSerializable((Object)tuple);
    }

    @Test
    void testRecursiveClass() {
        RecursiveClass recursiveClass = new RecursiveClass(new RecursiveClass());
        ClosureCleaner.clean((Object)recursiveClass, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        ClosureCleaner.ensureSerializable((Object)recursiveClass);
    }

    @Test
    void testWriteReplace() {
        WithWriteReplace.SerializablePayload writeReplace = new WithWriteReplace.SerializablePayload(new WithWriteReplace.Payload("text"));
        Assertions.assertThat((String)writeReplace.get().getRaw()).isEqualTo("text");
        ClosureCleaner.clean((Object)writeReplace, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.TOP_LEVEL, (boolean)true);
    }

    @Test
    void testWriteReplaceRecursive() {
        WithWriteReplace writeReplace = new WithWriteReplace(new WithWriteReplace.Payload("text"));
        Assertions.assertThat((String)writeReplace.getPayload().getRaw()).isEqualTo("text");
        ClosureCleaner.clean((Object)writeReplace, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    @Test
    void testCleanObject() {
        AssertionsForClassTypes.assertThatExceptionOfType(InvalidProgramException.class).isThrownBy(() -> ClosureCleaner.clean((Object)new Object(), (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true));
    }

    class InnerComplexMap
    implements MapFunction<Integer, Integer> {
        InnerCustomMap map1;
        LocalMap map3;

        public InnerComplexMap(MapFunction<Integer, Integer> map) {
            this.map1 = new InnerCustomMap();
            this.map3 = new LocalMap(map);
        }

        public Integer map(Integer value) throws Exception {
            return this.map1.map(value);
        }

        class LocalMap
        implements MapFunction<Integer, Integer> {
            MapFunction<Integer, Integer> map2;

            public LocalMap(MapFunction<Integer, Integer> map2) {
                this.map2 = map2;
            }

            public Integer map(Integer value) throws Exception {
                return (Integer)this.map2.map((Object)(value + 1));
            }
        }
    }

    class InnerCustomMap
    implements MapFunction<Integer, Integer> {
        InnerCustomMap() {
        }

        public Integer map(Integer value) throws Exception {
            return value + 1;
        }

        private void writeObject(ObjectOutputStream o) throws IOException {
        }

        private void readObject(ObjectInputStream i) throws IOException {
        }
    }
}

