/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.Random;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongValueComparator;
import org.apache.flink.api.common.typeutils.base.LongValueSerializer;
import org.apache.flink.types.LongValue;

class LongValueComparatorTest
extends ComparatorTestBase<LongValue> {
    LongValueComparatorTest() {
    }

    @Override
    protected TypeComparator<LongValue> createComparator(boolean ascending) {
        return new LongValueComparator(ascending);
    }

    @Override
    protected TypeSerializer<LongValue> createSerializer() {
        return new LongValueSerializer();
    }

    protected LongValue[] getSortedTestData() {
        Random rnd = new Random(874597969123412338L);
        long rndLong = rnd.nextLong();
        if (rndLong < 0L) {
            rndLong = -rndLong;
        }
        if (rndLong == Long.MAX_VALUE) {
            rndLong -= 3L;
        }
        if (rndLong <= 2L) {
            rndLong += 3L;
        }
        return new LongValue[]{new LongValue(Long.MIN_VALUE), new LongValue(-rndLong), new LongValue(-1L), new LongValue(0L), new LongValue(1L), new LongValue(2L), new LongValue(rndLong), new LongValue(Long.MAX_VALUE)};
    }
}

