/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;

class ListSerializerTest
extends SerializerTestBase<List<Long>> {
    ListSerializerTest() {
    }

    @Override
    protected TypeSerializer<List<Long>> createSerializer() {
        return new ListSerializer((TypeSerializer)LongSerializer.INSTANCE);
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<List<Long>> getTypeClass() {
        return List.class;
    }

    protected List<Long>[] getTestData() {
        Random rnd = new Random(123654789L);
        List list1 = Collections.emptyList();
        LinkedList list2 = new LinkedList();
        ArrayList list3 = new ArrayList();
        List<Long> list4 = Collections.singletonList(55L);
        LinkedList<Long> list5 = new LinkedList<Long>();
        list5.add(12345L);
        ArrayList<Long> list6 = new ArrayList<Long>();
        list6.add(777888L);
        LinkedList<Long> list7 = new LinkedList<Long>();
        for (int i = 0; i < rnd.nextInt(200); ++i) {
            list7.add(rnd.nextLong());
        }
        int list8Len = rnd.nextInt(200);
        ArrayList<Long> list8 = new ArrayList<Long>(list8Len);
        for (int i = 0; i < list8Len; ++i) {
            list8.add(rnd.nextLong());
        }
        return new List[]{list1, list2, list3, list4, list5, list6, list7, list8};
    }
}

