/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.Random;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ByteComparator;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;

class ByteComparatorTest
extends ComparatorTestBase<Byte> {
    ByteComparatorTest() {
    }

    @Override
    protected TypeComparator<Byte> createComparator(boolean ascending) {
        return new ByteComparator(ascending);
    }

    @Override
    protected TypeSerializer<Byte> createSerializer() {
        return new ByteSerializer();
    }

    protected Byte[] getSortedTestData() {
        Random rnd = new Random(874597969123412338L);
        int rndByte = rnd.nextInt(127);
        if (rndByte < 0) {
            rndByte = -rndByte;
        }
        if (rndByte == 127) {
            rndByte -= 3;
        }
        if (rndByte <= 2) {
            rndByte += 3;
        }
        return new Byte[]{(byte)-128, Integer.valueOf(-rndByte).byteValue(), Integer.valueOf(-1).byteValue(), Integer.valueOf(0).byteValue(), Integer.valueOf(1).byteValue(), Integer.valueOf(2).byteValue(), Integer.valueOf(rndByte).byteValue(), (byte)127};
    }
}

