/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class StateDescriptorTest {
    StateDescriptorTest() {
    }

    @Test
    void testInitializeWithSerializer() throws Exception {
        StringSerializer serializer = StringSerializer.INSTANCE;
        TestStateDescriptor descr = new TestStateDescriptor("test", serializer);
        Assertions.assertThat((boolean)descr.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isInstanceOf(StringSerializer.class);
        descr.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((boolean)descr.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isInstanceOf(StringSerializer.class);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assertions.assertThat((boolean)clone.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)clone.getSerializer()).isNotNull();
        Assertions.assertThat((Object)clone.getSerializer()).isInstanceOf(StringSerializer.class);
    }

    @Test
    void testInitializeSerializerBeforeSerialization() throws Exception {
        TestStateDescriptor<String> descr = new TestStateDescriptor<String>("test", String.class);
        Assertions.assertThat((boolean)descr.isSerializerInitialized()).isFalse();
        try {
            descr.getSerializer();
            Fail.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        descr.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((boolean)descr.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isInstanceOf(StringSerializer.class);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assertions.assertThat((boolean)clone.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)clone.getSerializer()).isNotNull();
        Assertions.assertThat((Object)clone.getSerializer()).isInstanceOf(StringSerializer.class);
    }

    @Test
    void testInitializeSerializerAfterSerialization() throws Exception {
        TestStateDescriptor<String> descr = new TestStateDescriptor<String>("test", String.class);
        Assertions.assertThat((boolean)descr.isSerializerInitialized()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> descr.getSerializer()).isInstanceOf(IllegalStateException.class)).describedAs("should fail with an exception", new Object[0]);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(descr));
        Assertions.assertThat((boolean)clone.isSerializerInitialized()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TestStateDescriptor)clone).getSerializer()).isInstanceOf(IllegalStateException.class)).describedAs("should fail with an exception", new Object[0]);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((boolean)clone.isSerializerInitialized()).isTrue();
        Assertions.assertThat((Object)clone.getSerializer()).isNotNull();
        Assertions.assertThat((Object)clone.getSerializer()).isInstanceOf(StringSerializer.class);
    }

    @Test
    void testInitializeSerializerAfterSerializationWithCustomConfig() throws Exception {
        ((AbstractIntegerAssert)Assertions.assertThat((int)new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl()).getKryo().getRegistration(File.class).getId()).as("broken test assumption", new Object[0])).isEqualTo(-1);
        ExecutionConfig config = new ExecutionConfig();
        ((SerializerConfigImpl)config.getSerializerConfig()).registerKryoType(File.class);
        TestStateDescriptor<Path> original = new TestStateDescriptor<Path>("test", Path.class);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(original));
        clone.initializeSerializerUnlessSet(config);
        Assertions.assertThat((((KryoSerializer)clone.getSerializer()).getKryo().getRegistration(File.class).getId() > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    void testSerializerDuplication() {
        KryoSerializer statefulSerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        TestStateDescriptor descr = new TestStateDescriptor("foobar", statefulSerializer);
        TypeSerializer serializerA = descr.getSerializer();
        TypeSerializer serializerB = descr.getSerializer();
        Assertions.assertThat((Object)serializerB).isNotSameAs((Object)serializerA);
    }

    @Test
    void testHashCodeAndEquals() throws Exception {
        String name = "testName";
        TestStateDescriptor<String> original = new TestStateDescriptor<String>("testName", String.class);
        TestStateDescriptor<String> same = new TestStateDescriptor<String>("testName", String.class);
        TestStateDescriptor sameBySerializer = new TestStateDescriptor("testName", StringSerializer.INSTANCE);
        Assertions.assertThat(same).hasSameHashCodeAs(original);
        Assertions.assertThat(sameBySerializer).hasSameHashCodeAs(original);
        Assertions.assertThat(same).isEqualTo(original);
        Assertions.assertThat(sameBySerializer).isEqualTo(original);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(original));
        Assertions.assertThat((Object)((Object)clone)).isEqualTo(original);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)((Object)clone)).isEqualTo(original);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat(same).isEqualTo(original);
    }

    @Test
    void testEqualsSameNameAndTypeDifferentClass() {
        String name = "test name";
        TestStateDescriptor<String> descr1 = new TestStateDescriptor<String>("test name", String.class);
        OtherTestStateDescriptor<String> descr2 = new OtherTestStateDescriptor<String>("test name", String.class);
        Assertions.assertThat(descr2).isNotEqualTo(descr1);
    }

    @Test
    void testSerializerLazyInitializeInParallel() throws Exception {
        String name = "testSerializerLazyInitializeInParallel";
        final TestStateDescriptor desc = new TestStateDescriptor("testSerializerLazyInitializeInParallel", new PojoTypeInfo(String.class, new ArrayList()));
        int threadNumber = 20;
        ArrayList<CheckedThread> threads = new ArrayList<CheckedThread>(20);
        final ExecutionConfig executionConfig = new ExecutionConfig();
        final ConcurrentHashMap serializers = new ConcurrentHashMap();
        for (int i = 0; i < 20; ++i) {
            threads.add(new CheckedThread(){

                public void go() {
                    desc.initializeSerializerUnlessSet(executionConfig);
                    TypeSerializer serializer = desc.getOriginalSerializer();
                    serializers.put(System.identityHashCode(serializer), serializer);
                }
            });
        }
        threads.forEach(Thread::start);
        for (CheckedThread t : threads) {
            t.sync();
        }
        ((MapAssert)Assertions.assertThat(serializers).as("Should use only one serializer but actually: " + serializers, new Object[0])).hasSize(1);
        threads.clear();
    }

    @Test
    void testStateTTlConfig() {
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("test-state", (TypeSerializer)IntSerializer.INSTANCE);
        stateDescriptor.enableTimeToLive(StateTtlConfig.newBuilder((Duration)Duration.ofMinutes(60L)).build());
        Assertions.assertThat((boolean)stateDescriptor.getTtlConfig().isEnabled()).isTrue();
        stateDescriptor.enableTimeToLive(StateTtlConfig.DISABLED);
        Assertions.assertThat((boolean)stateDescriptor.getTtlConfig().isEnabled()).isFalse();
    }

    private static class OtherTestStateDescriptor<T>
    extends StateDescriptor<State, T> {
        private static final long serialVersionUID = 1L;

        OtherTestStateDescriptor(String name, TypeSerializer<T> serializer) {
            super(name, serializer, null);
        }

        OtherTestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, null);
        }

        OtherTestStateDescriptor(String name, Class<T> type) {
            super(name, type, null);
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }

    private static class TestStateDescriptor<T>
    extends StateDescriptor<State, T> {
        private static final long serialVersionUID = 1L;

        TestStateDescriptor(String name, TypeSerializer<T> serializer) {
            super(name, serializer, null);
        }

        TestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, null);
        }

        TestStateDescriptor(String name, Class<T> type) {
            super(name, type, null);
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }
}

