/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReducingStateDescriptorTest {
    ReducingStateDescriptorTest() {
    }

    @Test
    void testReducingStateDescriptor() throws Exception {
        ReduceFunction & Serializable reducer = (ReduceFunction & Serializable)(a, b) -> a;
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        ReducingStateDescriptor descr = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, (TypeSerializer)serializer);
        Assertions.assertThat((String)descr.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isEqualTo((Object)serializer);
        Assertions.assertThat((Object)descr.getReduceFunction()).isEqualTo((Object)reducer);
        ReducingStateDescriptor copy = (ReducingStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assertions.assertThat((String)copy.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)copy.getSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getSerializer()).isEqualTo((Object)serializer);
    }

    @Test
    void testHashCodeEquals() throws Exception {
        String name = "testName";
        ReduceFunction & Serializable reducer = (ReduceFunction & Serializable)(a, b) -> a;
        ReducingStateDescriptor original = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, String.class);
        ReducingStateDescriptor same = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, String.class);
        ReducingStateDescriptor sameBySerializer = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, (TypeSerializer)StringSerializer.INSTANCE);
        Assertions.assertThat((Object)same).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)sameBySerializer).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
        Assertions.assertThat((Object)sameBySerializer).isEqualTo((Object)original);
        ReducingStateDescriptor clone = (ReducingStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
    }
}

