/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.StateDeclarations;
import org.apache.flink.api.common.typeinfo.TypeDescriptor;
import org.apache.flink.api.common.typeinfo.TypeDescriptors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AggregatingStateDeclarationTest {
    private AggregatingStateDeclaration<Integer, Integer, Integer> aggregatingStateDeclaration;
    private AggregateFunction<Integer, Integer, Integer> aggregateFunction;

    AggregatingStateDeclarationTest() {
    }

    @BeforeEach
    void setUp() {
        this.aggregateFunction = new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer add(Integer value, Integer accumulator) {
                return 0;
            }

            public Integer getResult(Integer accumulator) {
                return 0;
            }

            public Integer merge(Integer a, Integer b) {
                return 0;
            }
        };
        this.aggregatingStateDeclaration = StateDeclarations.aggregatingStateBuilder((String)"aggregatingState", (TypeDescriptor)TypeDescriptors.INT, this.aggregateFunction).build();
    }

    @Test
    void testAggregatingStateDeclarationName() {
        Assertions.assertThat((String)this.aggregatingStateDeclaration.getName()).isEqualTo("aggregatingState");
    }

    @Test
    void testAggregatingStateDeclarationFunc() {
        Assertions.assertThat((Object)this.aggregatingStateDeclaration.getAggregateFunction()).isEqualTo(this.aggregateFunction);
    }

    @Test
    void testAggregatingStateDeclarationType() {
        Assertions.assertThat((Object)this.aggregatingStateDeclaration.getTypeDescriptor()).isEqualTo((Object)TypeDescriptors.INT);
    }

    @Test
    void testAggregatingStateDeclarationDist() {
        Assertions.assertThat((Comparable)this.aggregatingStateDeclaration.getRedistributionMode()).isEqualTo((Object)StateDeclaration.RedistributionMode.NONE);
    }
}

