/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import org.apache.flink.api.common.serialization.AbstractDeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.JSONPObject;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractDeserializationSchemaTest {
    AbstractDeserializationSchemaTest() {
    }

    @Test
    void testTypeExtractionTuple() {
        TypeInformation type = new TupleSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assertions.assertThat((Object)type).isEqualTo((Object)expected);
    }

    @Test
    void testTypeExtractionTupleAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<Tuple2<byte[], byte[]>>(){

            public Tuple2<byte[], byte[]> deserialize(byte[] message) {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assertions.assertThat((Object)type).isEqualTo((Object)expected);
    }

    @Test
    void testTypeExtractionGeneric() {
        TypeInformation type = new JsonSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assertions.assertThat((Object)type).isEqualTo((Object)expected);
    }

    @Test
    void testTypeExtractionGenericAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<JSONPObject>(){

            public JSONPObject deserialize(byte[] message) {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assertions.assertThat((Object)type).isEqualTo((Object)expected);
    }

    @Test
    void testTypeExtractionRawException() {
        Assertions.assertThatThrownBy(() -> new RawSchema()).isInstanceOf(FlinkRuntimeException.class);
    }

    @Test
    void testTypeExtractionGenericException() {
        Assertions.assertThatThrownBy(() -> new GenericSchema()).isInstanceOf(FlinkRuntimeException.class);
    }

    @Test
    void testIndirectGenericExtension() {
        TypeInformation type = new IndirectExtension().getProducedType();
        Assertions.assertThat((Object)type).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    private static class IndirectExtension
    extends GenericSchema<String> {
        private IndirectExtension() {
        }

        @Override
        public String deserialize(byte[] message) {
            throw new UnsupportedOperationException();
        }
    }

    private static class GenericSchema<T>
    extends AbstractDeserializationSchema<T> {
        private GenericSchema() {
        }

        public T deserialize(byte[] message) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RawSchema
    extends AbstractDeserializationSchema {
        private RawSchema() {
        }

        public Object deserialize(byte[] message) {
            throw new UnsupportedOperationException();
        }
    }

    private static class JsonSchema
    extends AbstractDeserializationSchema<JSONPObject> {
        private JsonSchema() {
        }

        public JSONPObject deserialize(byte[] message) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TupleSchema
    extends AbstractDeserializationSchema<Tuple2<byte[], byte[]>> {
        private TupleSchema() {
        }

        public Tuple2<byte[], byte[]> deserialize(byte[] message) {
            throw new UnsupportedOperationException();
        }
    }
}

