/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.Iterator;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FieldListTest {
    FieldListTest() {
    }

    @Test
    void testFieldListConstructors() {
        FieldListTest.check(new FieldList(), new int[0]);
        FieldListTest.check(FieldList.EMPTY_LIST, new int[0]);
        FieldListTest.check(new FieldList(14), 14);
        FieldListTest.check(new FieldList(Integer.valueOf(3)), 3);
        FieldListTest.check(new FieldList(new int[]{7, 4, 1}), 7, 4, 1);
        FieldListTest.check(new FieldList(new int[]{7, 4, 1, 4, 7, 1, 4, 2}), 7, 4, 1, 4, 7, 1, 4, 2);
    }

    @Test
    void testFieldListAdds() {
        FieldListTest.check(new FieldList().addField(Integer.valueOf(1)).addField(Integer.valueOf(2)), 1, 2);
        FieldListTest.check(FieldList.EMPTY_LIST.addField(Integer.valueOf(3)).addField(Integer.valueOf(2)), 3, 2);
        FieldListTest.check(new FieldList(13).addFields((FieldSet)new FieldList(new int[]{17, 31, 42})), 13, 17, 31, 42);
        FieldListTest.check(new FieldList(14).addFields((FieldSet)new FieldList(17)), 14, 17);
        FieldListTest.check(new FieldList(3).addFields(new int[]{2, 8, 5, 7}), 3, 2, 8, 5, 7);
    }

    @Test
    void testImmutability() {
        FieldList s1 = new FieldList();
        FieldList s2 = new FieldList(5);
        FieldList s3 = new FieldList(Integer.valueOf(7));
        FieldList s4 = new FieldList(new int[]{5, 4, 7, 6});
        s1.addFields((FieldSet)s2).addFields((FieldSet)s3);
        s2.addFields((FieldSet)s4);
        s4.addFields((FieldSet)s1);
        s1.addField(Integer.valueOf(14));
        s2.addFields(new int[]{78, 13, 66, 3});
        Assertions.assertThat((Iterable)s1).isEmpty();
        Assertions.assertThat((Iterable)s2).hasSize(1);
        Assertions.assertThat((Iterable)s3).hasSize(1);
        Assertions.assertThat((Iterable)s4).hasSize(4);
    }

    @Test
    void testAddSetToList() {
        FieldListTest.check(new FieldList().addFields(new FieldSet(Integer.valueOf(1))).addFields(new int[]{2}), 1, 2);
        FieldListTest.check(new FieldList().addFields(new int[]{1}).addFields(new FieldSet(Integer.valueOf(2))), 1, 2);
        FieldListTest.check(new FieldList().addFields(new FieldSet(Integer.valueOf(2))), 2);
    }

    private static void check(FieldList set, int ... elements) {
        if (elements == null) {
            Assertions.assertThat((Iterable)set).isEmpty();
            return;
        }
        Assertions.assertThat((Iterable)set).hasSameSizeAs((Object)elements);
        for (int i : elements) {
            set.contains(Integer.valueOf(i));
        }
        int[] arr = set.toArray();
        Assertions.assertThat((int[])elements).isEqualTo((Object)arr);
        int[] fromIter = new int[set.size()];
        Iterator iter = set.iterator();
        for (int i = 0; i < fromIter.length; ++i) {
            fromIter[i] = (Integer)iter.next();
        }
        Assertions.assertThat((Iterator)iter).isExhausted();
        Assertions.assertThat((int[])elements).isEqualTo((Object)fromIter);
    }
}

