/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InnerJoinOperatorBaseTest
implements Serializable {
    InnerJoinOperatorBaseTest() {
    }

    @Test
    void testJoinPlain() throws Exception {
        FlatJoinFunction & Serializable joiner = (FlatJoinFunction & Serializable)(first, second, out) -> {
            out.collect((Object)first.length());
            out.collect((Object)second.length());
        };
        InnerJoinOperatorBase base = new InnerJoinOperatorBase((FlatJoinFunction)joiner, new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), new int[0], new int[0], "TestJoiner");
        ArrayList<String> inputData1 = new ArrayList<String>(Arrays.asList("foo", "bar", "foobar"));
        ArrayList<String> inputData2 = new ArrayList<String>(Arrays.asList("foobar", "foo"));
        ArrayList<Integer> expected = new ArrayList<Integer>(Arrays.asList(3, 3, 6, 6));
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        List resultSafe = base.executeOnCollections(inputData1, inputData2, null, executionConfig);
        executionConfig.enableObjectReuse();
        List resultRegular = base.executeOnCollections(inputData1, inputData2, null, executionConfig);
        Assertions.assertThat((List)resultSafe).isEqualTo(expected);
        Assertions.assertThat((List)resultRegular).isEqualTo(expected);
    }

    @Test
    void testJoinRich() throws Exception {
        final AtomicBoolean opened = new AtomicBoolean(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        String taskName = "Test rich join function";
        RichFlatJoinFunction<String, String, Integer> joiner = new RichFlatJoinFunction<String, String, Integer>(){

            public void open(OpenContext openContext) {
                opened.compareAndSet(false, true);
                Assertions.assertThat((int)this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask()).isZero();
                Assertions.assertThat((int)this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks()).isOne();
            }

            public void close() {
                closed.compareAndSet(false, true);
            }

            public void join(String first, String second, Collector<Integer> out) {
                out.collect((Object)first.length());
                out.collect((Object)second.length());
            }
        };
        InnerJoinOperatorBase base = new InnerJoinOperatorBase((FlatJoinFunction)joiner, new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), new int[0], new int[0], "Test rich join function");
        ArrayList<String> inputData1 = new ArrayList<String>(Arrays.asList("foo", "bar", "foobar"));
        ArrayList<String> inputData2 = new ArrayList<String>(Arrays.asList("foobar", "foo"));
        ArrayList<Integer> expected = new ArrayList<Integer>(Arrays.asList(3, 3, 6, 6));
        TaskInfoImpl taskInfo = new TaskInfoImpl("Test rich join function", 1, 0, 1, 0);
        HashMap accumulatorMap = new HashMap();
        HashMap cpTasks = new HashMap();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        List resultSafe = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        executionConfig.enableObjectReuse();
        List resultRegular = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assertions.assertThat((List)resultSafe).isEqualTo(expected);
        Assertions.assertThat((List)resultRegular).isEqualTo(expected);
        Assertions.assertThat((AtomicBoolean)opened).isTrue();
        Assertions.assertThat((AtomicBoolean)closed).isTrue();
    }
}

