/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.ExpressionKeysTest;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SelectorFunctionKeysTest {
    SelectorFunctionKeysTest() {
    }

    @Test
    void testAreCompatible1() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(ExpressionKeysTest.Pojo2.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Keys.SelectorFunctionKeys k1 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector1(), t1, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Keys.SelectorFunctionKeys k2 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector2(), (TypeInformation)t2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((boolean)k1.areCompatible((Keys)k2)).isTrue();
        Assertions.assertThat((boolean)k2.areCompatible((Keys)k1)).isTrue();
    }

    @Test
    void testAreCompatible2() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(ExpressionKeysTest.PojoWithMultiplePojos.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.getForClass(ExpressionKeysTest.Pojo1.class), BasicTypeInfo.INT_TYPE_INFO});
        TupleTypeInfo kt = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Keys.SelectorFunctionKeys k1 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector3(), t1, (TypeInformation)kt);
        Keys.SelectorFunctionKeys k2 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector4(), (TypeInformation)t2, (TypeInformation)kt);
        Assertions.assertThat((boolean)k1.areCompatible((Keys)k2)).isTrue();
        Assertions.assertThat((boolean)k2.areCompatible((Keys)k1)).isTrue();
    }

    @Test
    void testAreCompatible3() throws Keys.IncompatibleKeysException {
        BasicTypeInfo t1 = BasicTypeInfo.STRING_TYPE_INFO;
        TypeInformation t2 = TypeExtractor.getForClass(ExpressionKeysTest.Pojo2.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("*", (TypeInformation)t1);
        Keys.SelectorFunctionKeys sk2 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector1(), t2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((boolean)sk2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testAreCompatible4() throws Keys.IncompatibleKeysException {
        TupleTypeInfo t1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        TypeInformation t2 = TypeExtractor.getForClass(ExpressionKeysTest.PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new int[]{2, 0}, (TypeInformation)t1);
        Keys.SelectorFunctionKeys sk2 = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector3(), t2, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assertions.assertThat((boolean)sk2.areCompatible((Keys)ek1)).isTrue();
    }

    @Test
    void testOriginalTypes1() {
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Keys.SelectorFunctionKeys k = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector2(), (TypeInformation)t2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object[])k.getOriginalKeyFieldTypes()).containsExactly((Object[])new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO});
    }

    @Test
    void testOriginalTypes2() {
        TupleTypeInfo t1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        TypeInformation t2 = TypeExtractor.getForClass(ExpressionKeysTest.PojoWithMultiplePojos.class);
        Keys.SelectorFunctionKeys sk = new Keys.SelectorFunctionKeys((KeySelector)new KeySelector3(), t2, (TypeInformation)t1);
        Assertions.assertThat((Object[])sk.getOriginalKeyFieldTypes()).isEqualTo((Object)new TypeInformation[]{t1});
    }

    public static class KeySelector4
    implements KeySelector<Tuple3<Long, ExpressionKeysTest.Pojo1, Integer>, Tuple2<Integer, String>> {
        public Tuple2<Integer, String> getKey(Tuple3<Long, ExpressionKeysTest.Pojo1, Integer> v) {
            return new Tuple2((Object)((Integer)v.f2), (Object)((ExpressionKeysTest.Pojo1)v.f1).a);
        }
    }

    public static class KeySelector3
    implements KeySelector<ExpressionKeysTest.PojoWithMultiplePojos, Tuple2<Integer, String>> {
        public Tuple2<Integer, String> getKey(ExpressionKeysTest.PojoWithMultiplePojos v) {
            return new Tuple2((Object)v.i0, (Object)v.p1.b);
        }
    }

    public static class KeySelector2
    implements KeySelector<Tuple2<Integer, String>, String> {
        public String getKey(Tuple2<Integer, String> v) {
            return (String)v.f1;
        }
    }

    public static class KeySelector1
    implements KeySelector<ExpressionKeysTest.Pojo2, String> {
        public String getKey(ExpressionKeysTest.Pojo2 v) {
            return v.b2;
        }
    }
}

